/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.metrics.graph.entropy;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import org.mosim.refactorlizar.architecture.evaluation.codemetrics.CodeMetric;
import org.mosim.refactorlizar.architecture.evaluation.codemetrics.LinesOfCode;
import teetime.framework.AbstractConsumerStage;

public class SaveMultipleResultsAllenMetricSink
extends AbstractConsumerStage<Map<Class<? extends CodeMetric>, CodeMetric>> {
    private final BufferedWriter writer;
    private int counter;
    private final Class<? extends CodeMetric>[] metricClasses;
    private final String valueSeparator;
    private final String newline;

    @SafeVarargs
    public SaveMultipleResultsAllenMetricSink(Path outputPath, String newline, String valueSeparator, Class<? extends CodeMetric> ... metrics) throws IOException {
        this.newline = newline;
        this.valueSeparator = valueSeparator;
        this.writer = Files.newBufferedWriter(outputPath, new OpenOption[0]);
        this.metricClasses = metrics;
        for (int i = 0; i < metrics.length; ++i) {
            if (i > 0) {
                this.writer.write(valueSeparator);
            }
            this.writer.write(metrics[i].getSimpleName());
        }
        this.writer.write(newline);
    }

    protected void execute(Map<Class<? extends CodeMetric>, CodeMetric> valueMap) throws IOException {
        this.logger.info("Output line {}", (Object)(++this.counter));
        boolean separator = false;
        for (Class<? extends CodeMetric> metricClass : this.metricClasses) {
            if (separator) {
                this.writer.write(this.valueSeparator);
            } else {
                separator = true;
            }
            if (metricClass.equals(LinesOfCode.class)) {
                this.findElementInteger(LinesOfCode.class, valueMap);
                continue;
            }
            this.findElement(metricClass, valueMap);
        }
        this.writer.write(this.newline);
        this.writer.flush();
    }

    private void findElement(Class<? extends CodeMetric> clazz, Map<Class<? extends CodeMetric>, CodeMetric> metrics) throws IOException {
        CodeMetric metric = metrics.get(clazz);
        if (metric != null) {
            this.writer.write(String.format("%f", metric.getValue()));
        }
    }

    private void findElementInteger(Class<? extends CodeMetric> clazz, Map<Class<? extends CodeMetric>, CodeMetric> metrics) throws IOException {
        CodeMetric metric = metrics.get(clazz);
        if (metric != null) {
            this.writer.write(String.format("%d", (int)metric.getValue()));
        }
    }

    protected void onTerminating() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            this.logger.error("Could not close writer.");
        }
        super.onTerminating();
    }
}

