/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kieker.analysis.AnalysisController;
import kieker.analysis.IProjectContext;
import kieker.analysis.analysisComponent.AbstractAnalysisComponent;
import kieker.analysis.exception.AnalysisConfigurationException;
import kieker.analysis.plugin.Display;
import kieker.analysis.plugin.IPlugin;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.analysis.plugin.reader.IReaderPlugin;
import kieker.analysis.repository.AbstractRepository;
import kieker.common.configuration.Configuration;
import kieker.common.record.misc.KiekerMetadataRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Plugin
public abstract class AbstractPlugin
extends AbstractAnalysisComponent
implements IPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)AbstractPlugin.class.getCanonicalName());
    private final ConcurrentHashMap<String, List<IPlugin.PluginInputPortReference>> registeredMethods;
    private final ConcurrentHashMap<String, AbstractRepository> registeredRepositories;
    private final Map<OutputPort, Class<?>[]> outputPortTypes;
    private final Map<String, RepositoryPort> repositoryPorts;
    private final Map<String, OutputPort> outputPorts;
    private final Map<String, InputPort> inputPorts;
    private final List<AbstractPlugin> incomingPlugins;
    private final List<AbstractPlugin> outgoingPlugins;
    private volatile IPlugin.STATE state = IPlugin.STATE.READY;

    public AbstractPlugin(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        InputPort inputPort;
        this.repositoryPorts = new ConcurrentHashMap<String, RepositoryPort>();
        this.outputPorts = new ConcurrentHashMap<String, OutputPort>();
        this.outputPortTypes = new ConcurrentHashMap<OutputPort, Class<?>[]>();
        Plugin annotation = this.getClass().getAnnotation(Plugin.class);
        for (RepositoryPort repositoryPort : annotation.repositoryPorts()) {
            if (this.repositoryPorts.put(repositoryPort.name(), repositoryPort) == null) continue;
            this.logger.error("Two RepositoryPorts use the same name: {}", (Object)repositoryPort.name());
        }
        for (Annotation annotation2 : annotation.outputPorts()) {
            Class<?>[] outTypes;
            if (this.outputPorts.put(annotation2.name(), (OutputPort)annotation2) != null) {
                this.logger.error("Two OutputPorts use the same name: {}", (Object)annotation2.name());
            }
            if ((outTypes = annotation2.eventTypes()).length == 0) {
                outTypes = new Class[]{Object.class};
            }
            this.outputPortTypes.put((OutputPort)annotation2, outTypes);
        }
        this.inputPorts = new ConcurrentHashMap<String, InputPort>();
        if (!(this instanceof IReaderPlugin)) {
            for (Method method : this.getClass().getMethods()) {
                inputPort = method.getAnnotation(InputPort.class);
                if (inputPort != null && this.inputPorts.put(inputPort.name(), inputPort) != null) {
                    this.logger.error("Two InputPorts use the same name: {}", (Object)inputPort.name());
                }
                if (inputPort == null) continue;
                Class<?>[] parameters = method.getParameterTypes();
                if (parameters.length != 1) {
                    this.logger.error("The input port {} has to provide exactly one parameter of the correct type.", (Object)inputPort.name());
                    continue;
                }
                Class<?>[] eventTypes = inputPort.eventTypes();
                if (eventTypes.length == 0) {
                    eventTypes = new Class[]{Object.class};
                }
                for (Class<?> event : eventTypes) {
                    if (parameters[0].isAssignableFrom(event)) continue;
                    this.logger.error("The event type {} of the input port {} is not accepted by the parameter of type ", new Object[]{event.getName(), inputPort.name(), parameters[0].getName()});
                }
            }
        } else {
            for (Method method : this.getClass().getMethods()) {
                inputPort = method.getAnnotation(InputPort.class);
                if (inputPort == null) continue;
                this.logger.warn("Invalid port for reader detected. Port is ignored: {}", (Object)inputPort.name());
            }
        }
        this.registeredRepositories = new ConcurrentHashMap(this.repositoryPorts.size());
        this.registeredMethods = new ConcurrentHashMap();
        for (OutputPort outputPort : annotation.outputPorts()) {
            this.registeredMethods.put(outputPort.name(), new ArrayList(1));
        }
        this.incomingPlugins = new ArrayList<AbstractPlugin>(1);
        this.outgoingPlugins = new ArrayList<AbstractPlugin>(1);
    }

    protected final boolean deliver(String outputPortName, Object data) {
        if (this.state != IPlugin.STATE.RUNNING && this.state != IPlugin.STATE.TERMINATING || data == null) {
            return false;
        }
        if (data instanceof KiekerMetadataRecord) {
            ((AnalysisController)this.projectContext).handleKiekerMetadataRecord((KiekerMetadataRecord)data);
            return true;
        }
        OutputPort outputPort = this.outputPorts.get(outputPortName);
        if (outputPort == null) {
            return false;
        }
        Class<?>[] outTypes = this.outputPortTypes.get(outputPort);
        boolean outTypeMatch = false;
        for (Class<?> eventType : outTypes) {
            if (!eventType.isInstance(data)) continue;
            outTypeMatch = true;
            break;
        }
        if (!outTypeMatch) {
            return false;
        }
        List<IPlugin.PluginInputPortReference> registeredPortMethods = this.registeredMethods.get(outputPortName);
        block4: for (IPlugin.PluginInputPortReference pluginInputPortReference : registeredPortMethods) {
            Class<?>[] eventTypes = pluginInputPortReference.getEventTypes();
            if (eventTypes.length == 0) {
                eventTypes = new Class[]{Object.class};
            }
            for (Class<?> eventType : eventTypes) {
                if (!eventType.isAssignableFrom(data.getClass())) continue;
                try {
                    pluginInputPortReference.getInputPortMethod().invoke((Object)pluginInputPortReference.getPlugin(), data);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    this.logger.warn("Caught exception when sending data from {}: OutputPort {} to {}'s InputPort {}", new Object[]{this.getClass().getName(), outputPort.name(), pluginInputPortReference.getPlugin().getClass().getName(), pluginInputPortReference.getInputPortMethod().getName(), cause});
                }
                catch (Exception e) {
                    this.logger.error("Caught exception when invoking {}'s InputPort {}", new Object[]{pluginInputPortReference.getPlugin().getClass().getName(), pluginInputPortReference.getInputPortMethod().getName(), e});
                }
                continue block4;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void connect(String reponame, AbstractRepository repository) throws AnalysisConfigurationException {
        if (this.state != IPlugin.STATE.READY) {
            throw new AnalysisConfigurationException("Plugin: " + this.getClass().getName() + " final not in " + IPlugin.STATE.READY + " this.state, but final in state " + this.state + ".");
        }
        RepositoryPort port = this.repositoryPorts.get(reponame);
        if (port == null) {
            throw new AnalysisConfigurationException("Failed to connect plugin '" + this.getName() + "' (" + this.getPluginName() + ") to repository '" + repository.getName() + "' (" + repository.getRepositoryName() + "). Unknown repository port: " + reponame);
        }
        Class<? extends AbstractRepository> repositoryType = port.repositoryType();
        if (!repositoryType.isAssignableFrom(repository.getClass())) {
            throw new AnalysisConfigurationException("Failed to connect plugin '" + this.getName() + "' (" + this.getPluginName() + ") to repository '" + repository.getName() + "' (" + repository.getRepositoryName() + "). Expected RepositoryType: " + repositoryType.getName() + " Found: " + repository.getClass().getName());
        }
        AbstractPlugin abstractPlugin = this;
        synchronized (abstractPlugin) {
            if (this.registeredRepositories.containsKey(reponame)) {
                throw new AnalysisConfigurationException("Failed to connect plugin '" + this.getName() + "' (" + this.getPluginName() + ") to repository '" + repository.getName() + "' (" + repository.getRepositoryName() + "). RepositoryPort already connected: " + reponame);
            }
            this.registeredRepositories.put(reponame, repository);
        }
    }

    public static final void connect(AbstractPlugin src, String outputPortName, AbstractPlugin dst, String inputPortName) throws AnalysisConfigurationException {
        if (!AbstractPlugin.isConnectionAllowed(src, outputPortName, dst, inputPortName)) {
            throw new AnalysisConfigurationException("Failed to connect plugin '" + src.getName() + "' (" + src.getPluginName() + ") to plugin '" + dst.getName() + "' (" + dst.getPluginName() + ").");
        }
        for (final Method m : dst.getClass().getMethods()) {
            InputPort ip = m.getAnnotation(InputPort.class);
            if (ip == null || m.getParameterTypes().length != 1 || !ip.name().equals(inputPortName)) continue;
            src.outputPorts.get(outputPortName).eventTypes();
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    m.setAccessible(true);
                    return null;
                }
            });
            src.registeredMethods.get(outputPortName).add(new IPlugin.PluginInputPortReference(dst, inputPortName, m, dst.inputPorts.get(inputPortName).eventTypes()));
            src.outgoingPlugins.add(dst);
            dst.incomingPlugins.add(src);
            src.notifyNewOutgoingConnection(outputPortName, dst, inputPortName);
            dst.notifyNewIncomingConnection(inputPortName, src, outputPortName);
            return;
        }
        throw new AnalysisConfigurationException("Failed to connect plugin '" + src.getName() + "' (" + src.getPluginName() + ") to plugin '" + dst.getName() + "' (" + dst.getPluginName() + ").");
    }

    public static final boolean isConnectionAllowed(AbstractPlugin src, String output, AbstractPlugin dst, String input) {
        if (src == null || dst == null || dst instanceof IReaderPlugin) {
            LOGGER.warn("Plugins are invalid or null.");
            return false;
        }
        if (src.state != IPlugin.STATE.READY) {
            LOGGER.warn("Plugin: {} not in {} state, but in state {}.", new Object[]{src.getClass().getName(), IPlugin.STATE.READY, src.state});
            return false;
        }
        if (dst.state != IPlugin.STATE.READY) {
            LOGGER.warn("Plugin: {} not in {} state, but in state {}.", new Object[]{dst.getClass().getName(), IPlugin.STATE.READY, dst.state});
            return false;
        }
        OutputPort outputPort = src.outputPorts.get(output);
        if (outputPort == null) {
            LOGGER.warn("Output port does not exist. Plugin: {}; output: {}", (Object)src.getClass().getName(), (Object)output);
            return false;
        }
        InputPort inputPort = dst.inputPorts.get(input);
        if (inputPort == null) {
            LOGGER.warn("Input port does not exist. Plugin: {}; output: {}", (Object)dst.getClass().getName(), (Object)input);
            return false;
        }
        if (inputPort.eventTypes().length != 0) {
            Class<Object>[] outEventTypes = outputPort.eventTypes().length == 0 ? new Class[]{Object.class} : outputPort.eventTypes();
            for (Class<?> clazz : outEventTypes) {
                for (Class<?> dstEventType : inputPort.eventTypes()) {
                    if (!dstEventType.isInterface() && !clazz.isInterface() && !dstEventType.isAssignableFrom(clazz) && !clazz.isAssignableFrom(dstEventType)) continue;
                    return true;
                }
            }
            String allowedOutputTypes = Arrays.toString(outputPort.eventTypes());
            String allowedInputTypes = Arrays.toString(inputPort.eventTypes());
            LOGGER.warn("Output port '{}' ({}) is not compatible with input port '{}' ({}).", new Object[]{output, allowedOutputTypes, input, allowedInputTypes});
            return false;
        }
        return true;
    }

    @Override
    protected final Configuration getDefaultConfiguration() {
        Property[] propertyAnnotations;
        Configuration defaultConfiguration = new Configuration();
        Plugin pluginAnnotation = this.getClass().getAnnotation(Plugin.class);
        for (Property property : propertyAnnotations = pluginAnnotation.configuration()) {
            defaultConfiguration.setProperty(property.name(), property.defaultValue());
        }
        return defaultConfiguration;
    }

    @Override
    public final String getPluginName() {
        String pluginName = this.getClass().getAnnotation(Plugin.class).name();
        if (pluginName.equals("")) {
            return this.getClass().getSimpleName();
        }
        return pluginName;
    }

    @Override
    public final String getPluginDescription() {
        return this.getClass().getAnnotation(Plugin.class).description();
    }

    public final boolean areAllRepositoryPortsConnected() {
        for (String element : this.repositoryPorts.keySet()) {
            if (this.registeredRepositories.containsKey(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final Map<String, AbstractRepository> getCurrentRepositories() {
        return Collections.unmodifiableMap(this.registeredRepositories);
    }

    protected final AbstractRepository getRepository(String reponame) {
        return this.registeredRepositories.get(reponame);
    }

    @Override
    public final String[] getAllOutputPortNames() {
        LinkedList<String> outputNames = new LinkedList<String>();
        Plugin annotation = this.getClass().getAnnotation(Plugin.class);
        for (OutputPort outputPort : annotation.outputPorts()) {
            outputNames.add(outputPort.name());
        }
        return outputNames.toArray(new String[outputNames.size()]);
    }

    @Override
    public final String[] getAllInputPortNames() {
        LinkedList<String> inputNames = new LinkedList<String>();
        for (Method method : this.getClass().getMethods()) {
            InputPort inputPort = method.getAnnotation(InputPort.class);
            if (inputPort == null || method.getParameterTypes().length != 1) continue;
            inputNames.add(inputPort.name());
        }
        return inputNames.toArray(new String[inputNames.size()]);
    }

    @Override
    public final String[] getAllDisplayNames() {
        LinkedList<String> displayNames = new LinkedList<String>();
        for (Method method : this.getClass().getMethods()) {
            Display display = method.getAnnotation(Display.class);
            if (display == null) continue;
            displayNames.add(display.name());
        }
        return displayNames.toArray(new String[displayNames.size()]);
    }

    @Override
    public final String[] getAllRepositoryPortNames() {
        LinkedList<String> repositoryNames = new LinkedList<String>();
        Plugin annotation = this.getClass().getAnnotation(Plugin.class);
        for (RepositoryPort repositoryPort : annotation.repositoryPorts()) {
            repositoryNames.add(repositoryPort.name());
        }
        return repositoryNames.toArray(new String[repositoryNames.size()]);
    }

    @Override
    public final List<IPlugin.PluginInputPortReference> getConnectedPlugins(String outputPortName) {
        OutputPort outputPort = this.outputPorts.get(outputPortName);
        if (outputPort == null) {
            return null;
        }
        ArrayList<IPlugin.PluginInputPortReference> results = new ArrayList<IPlugin.PluginInputPortReference>();
        for (IPlugin.PluginInputPortReference ref : this.registeredMethods.get(outputPortName)) {
            results.add(ref);
        }
        return results;
    }

    @Override
    public final IPlugin.STATE getState() {
        return this.state;
    }

    public final boolean start() {
        if (this.state != IPlugin.STATE.READY) {
            return false;
        }
        this.state = IPlugin.STATE.RUNNING;
        return this.init();
    }

    public final void shutdown(boolean error) {
        if (this.state != IPlugin.STATE.READY && this.state != IPlugin.STATE.RUNNING) {
            return;
        }
        this.state = error ? IPlugin.STATE.FAILING : IPlugin.STATE.TERMINATING;
        for (AbstractPlugin plugin : this.incomingPlugins) {
            plugin.shutdown(error);
        }
        this.terminate(error);
        this.state = error ? IPlugin.STATE.FAILED : IPlugin.STATE.TERMINATED;
        for (AbstractPlugin plugin : this.outgoingPlugins) {
            plugin.shutdown(error);
        }
    }

    public Set<AbstractPlugin> getIncomingPlugins(boolean transitive) {
        HashSet<AbstractPlugin> knownIncomingPlugins = new HashSet<AbstractPlugin>();
        this.addIncomingPlugins(knownIncomingPlugins, transitive);
        return knownIncomingPlugins;
    }

    private void addIncomingPlugins(Set<AbstractPlugin> knownIncomingPlugins, boolean transitive) {
        for (AbstractPlugin plugin : this.incomingPlugins) {
            knownIncomingPlugins.add(plugin);
            if (!transitive) continue;
            plugin.addIncomingPlugins(knownIncomingPlugins, transitive);
        }
    }

    protected void notifyNewIncomingConnection(String inputPortName, AbstractPlugin connectedPlugin, String outputPortName) throws AnalysisConfigurationException {
    }

    protected void notifyNewOutgoingConnection(String outputPortName, AbstractPlugin connectedPlugin, String inputPortName) throws AnalysisConfigurationException {
    }
}

