/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.filter.forward.util;

import java.lang.ref.SoftReference;
import java.util.concurrent.locks.ReentrantLock;

@Deprecated
public class KiekerHashMap {
    private static final int INITIAL_CAPACITY = 16;
    private static final double LOAD_FACTOR = 0.75;
    private static final int CONCURRENCY_LEVEL = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private final int segmentMask;
    private final int segmentShift;
    private final Segment[] segments;

    public KiekerHashMap() {
        int cap;
        int ssize;
        int sshift = 0;
        for (ssize = 1; ssize < 16; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = new Segment[ssize];
        int c = 16 / ssize;
        if (c * ssize < 16) {
            ++c;
        }
        for (cap = 1; cap < c; cap <<= 1) {
        }
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment(cap, 0.75);
        }
    }

    private static final int hash(String value) {
        int h = value.hashCode();
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    public final String get(String value) {
        int hash = KiekerHashMap.hash(value);
        return this.segments[hash >>> this.segmentShift & this.segmentMask].get(value, hash);
    }

    private static final class Segment
    extends ReentrantLock {
        private static final long serialVersionUID = 1L;
        private volatile int count;
        private HashEntry[] table;
        private int threshold;

        protected Segment(int initialCapacity, double lf) {
            this.table = new HashEntry[initialCapacity];
            this.threshold = (int)((double)initialCapacity * lf);
            this.count = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final String get(String value, int hash) {
            String cachedString;
            HashEntry e = null;
            if (this.count != 0) {
                HashEntry first;
                HashEntry[] tab = this.table;
                int index = hash & tab.length - 1;
                e = first = tab[index];
                while (e != null) {
                    if (e.hash == hash && value.equals(cachedString = (String)e.get())) {
                        return cachedString;
                    }
                    e = e.next;
                }
            }
            this.lock();
            try {
                HashEntry first;
                int c = this.count + 1;
                if (c >= this.threshold) {
                    this.cleanup();
                    if (c >= this.threshold) {
                        this.rehash();
                    }
                    this.count = c;
                }
                HashEntry[] tab = this.table;
                int index = hash & tab.length - 1;
                e = first = tab[index];
                while (e != null) {
                    if (e.hash == hash && value.equals(cachedString = (String)e.get())) {
                        String string = cachedString;
                        return string;
                    }
                    e = e.next;
                }
                tab[index] = new HashEntry(value, hash, first);
                this.count = c;
                String string = value;
                return string;
            }
            finally {
                this.unlock();
            }
        }

        private final void cleanup() {
            int c = this.count;
            HashEntry[] tab = this.table;
            for (int index = 0; index < tab.length; ++index) {
                HashEntry e = tab[index];
                while (e != null && e.get() == null) {
                    e = e.next;
                    --c;
                }
                if (e == null) {
                    tab[index] = null;
                    continue;
                }
                HashEntry first = new HashEntry((String)e.get(), e.hash, null);
                e = e.next;
                while (e != null) {
                    String s = (String)e.get();
                    if (s != null) {
                        first = new HashEntry(s, e.hash, first);
                    } else {
                        --c;
                    }
                    e = e.next;
                }
                tab[index] = first;
            }
            this.count = --c;
        }

        private final void rehash() {
            HashEntry[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x40000000) {
                return;
            }
            HashEntry[] newTable = new HashEntry[oldCapacity << 1];
            this.threshold = (int)((double)newTable.length * 0.75);
            int sizeMask = newTable.length - 1;
            for (int i = 0; i < oldCapacity; ++i) {
                int k;
                HashEntry e = oldTable[i];
                if (e == null) continue;
                HashEntry next = e.next;
                int idx = e.hash & sizeMask;
                if (next == null) {
                    newTable[idx] = e;
                    continue;
                }
                HashEntry lastRun = e;
                int lastIdx = idx;
                HashEntry last = next;
                while (last != null) {
                    k = last.hash & sizeMask;
                    if (k != lastIdx) {
                        lastIdx = k;
                        lastRun = last;
                    }
                    last = last.next;
                }
                newTable[lastIdx] = lastRun;
                HashEntry p = e;
                while (p != lastRun) {
                    k = p.hash & sizeMask;
                    HashEntry n = newTable[k];
                    newTable[k] = new HashEntry((String)p.get(), p.hash, n);
                    p = p.next;
                }
            }
            this.table = newTable;
        }
    }

    private static final class HashEntry
    extends SoftReference<String> {
        final int hash;
        final HashEntry next;

        protected HashEntry(String value, int hash, HashEntry next) {
            super(value);
            this.hash = hash;
            this.next = next;
        }
    }
}

