/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.filter.record;

import java.util.concurrent.TimeUnit;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;

@Deprecated
@Plugin(description="A filter computing the throughput of the monitoring", outputPorts={@OutputPort(name="relayedRecords", eventTypes={IMonitoringRecord.class}, description="Provides each incoming record"), @OutputPort(name="uncountedRecords", eventTypes={IMonitoringRecord.class}, description="Provides each not counted record"), @OutputPort(name="throughput", eventTypes={Long.class}, description="Provides throughput within last interval")}, configuration={@Property(name="timeunit", defaultValue="SECONDS"), @Property(name="intervalsize", defaultValue="1")})
public class MonitoringThroughputFilter
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME_RECORDS = "inputRecords";
    public static final String OUTPUT_PORT_NAME_RELAYED_RECORDS = "relayedRecords";
    public static final String OUTPUT_PORT_NAME_UNCOUNTED_RECORDS = "uncountedRecords";
    public static final String OUTPUT_PORT_NAME_THROUGHPUT = "throughput";
    public static final String CONFIG_PROPERTY_NAME_TIMEUNIT = "timeunit";
    public static final String CONFIG_PROPERTY_VALUE_TIMEUNIT = "SECONDS";
    public static final String CONFIG_PROPERTY_NAME_INTERVAL_SIZE = "intervalsize";
    public static final String CONFIG_PROPERTY_VALUE_INTERVAL_SIZE_ONE_SECOND = "1";
    private final TimeUnit timeunit = this.recordsTimeUnitFromProjectContext;
    private final long intervalSize;
    private long currentInterval = -1L;
    private long recordsInInterval;

    public MonitoringThroughputFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        TimeUnit configTimeunit;
        String configTimeunitProperty = configuration.getStringProperty(CONFIG_PROPERTY_NAME_TIMEUNIT);
        try {
            configTimeunit = TimeUnit.valueOf(configTimeunitProperty);
        }
        catch (IllegalArgumentException ex) {
            this.logger.warn("{} is no valid TimeUnit! Using inherited value of {} instead.", (Object)configTimeunitProperty, (Object)this.timeunit.name());
            configTimeunit = this.timeunit;
        }
        this.intervalSize = this.timeunit.convert(configuration.getLongProperty(CONFIG_PROPERTY_NAME_INTERVAL_SIZE), configTimeunit);
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_TIMEUNIT, this.timeunit.name());
        configuration.setProperty(CONFIG_PROPERTY_NAME_INTERVAL_SIZE, Long.toString(this.intervalSize));
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InputPort(name="inputRecords", eventTypes={IMonitoringRecord.class}, description="Receives incoming records to calculate the throughput")
    public final void inputRecord(IMonitoringRecord record) {
        long timestamp = record.getLoggingTimestamp();
        long interval = timestamp / this.intervalSize;
        MonitoringThroughputFilter monitoringThroughputFilter = this;
        synchronized (monitoringThroughputFilter) {
            if (interval < this.currentInterval) {
                super.deliver(OUTPUT_PORT_NAME_UNCOUNTED_RECORDS, record);
            } else {
                if (interval > this.currentInterval) {
                    if (this.currentInterval != -1L) {
                        super.deliver(OUTPUT_PORT_NAME_THROUGHPUT, this.recordsInInterval);
                        for (long i = this.currentInterval + 1L; i < interval; ++i) {
                            super.deliver(OUTPUT_PORT_NAME_THROUGHPUT, 0L);
                        }
                    }
                    this.currentInterval = interval;
                    this.recordsInInterval = 0L;
                }
                ++this.recordsInInterval;
            }
        }
        super.deliver(OUTPUT_PORT_NAME_RELAYED_RECORDS, record);
    }
}

