/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.filter.select;

import java.util.Set;
import java.util.TreeSet;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.controlflow.OperationExecutionRecord;
import kieker.common.record.flow.IFlowRecord;
import kieker.common.record.flow.ITraceRecord;
import kieker.common.record.flow.trace.AbstractTraceEvent;
import kieker.common.record.flow.trace.TraceMetadata;

@Deprecated
@Plugin(description="A filter allowing to filter incoming objects based on their trace ID", outputPorts={@OutputPort(name="recordsMatchingId", description="Forwards events with matching trace IDs", eventTypes={AbstractTraceEvent.class, TraceMetadata.class, OperationExecutionRecord.class}), @OutputPort(name="recordsNotMatchingId", description="Forwards events with trace IDs not matching", eventTypes={AbstractTraceEvent.class, TraceMetadata.class, OperationExecutionRecord.class})}, configuration={@Property(name="acceptAllTraces", defaultValue="true"), @Property(name="selectedTraceIds", defaultValue="")})
public final class TraceIdFilter
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME_FLOW = "monitoringRecordsFlow";
    public static final String INPUT_PORT_NAME_EXECUTION = "monitoringRecordsExecution";
    public static final String INPUT_PORT_NAME_COMBINED = "monitoringRecordsCombined";
    public static final String OUTPUT_PORT_NAME_MATCH = "recordsMatchingId";
    public static final String OUTPUT_PORT_NAME_MISMATCH = "recordsNotMatchingId";
    public static final String CONFIG_PROPERTY_NAME_SELECT_ALL_TRACES = "acceptAllTraces";
    public static final String CONFIG_PROPERTY_NAME_SELECTED_TRACES = "selectedTraceIds";
    private final boolean acceptAllTraces;
    private final Set<Long> selectedTraceIds;

    public TraceIdFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        this.acceptAllTraces = configuration.getBooleanProperty(CONFIG_PROPERTY_NAME_SELECT_ALL_TRACES);
        this.selectedTraceIds = new TreeSet<Long>();
        for (String id : configuration.getStringArrayProperty(CONFIG_PROPERTY_NAME_SELECTED_TRACES)) {
            this.selectedTraceIds.add(Long.parseLong(id));
        }
    }

    @Override
    public final Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_SELECT_ALL_TRACES, Boolean.toString(this.acceptAllTraces));
        configuration.setProperty(CONFIG_PROPERTY_NAME_SELECTED_TRACES, Configuration.toProperty(this.selectedTraceIds.toArray()));
        return configuration;
    }

    private final boolean acceptId(long traceId) {
        return this.acceptAllTraces || this.selectedTraceIds.contains(traceId);
    }

    @InputPort(name="monitoringRecordsCombined", description="Receives execution and trace events to be selected by trace ID", eventTypes={ITraceRecord.class, TraceMetadata.class, OperationExecutionRecord.class})
    public void inputCombined(IMonitoringRecord record) {
        if (record instanceof OperationExecutionRecord) {
            this.inputOperationExecutionRecord((OperationExecutionRecord)record);
        } else if (record instanceof ITraceRecord || record instanceof TraceMetadata) {
            this.inputTraceEvent((IFlowRecord)record);
        }
    }

    @InputPort(name="monitoringRecordsFlow", description="Receives trace events to be selected by trace ID", eventTypes={ITraceRecord.class, TraceMetadata.class})
    public void inputTraceEvent(IFlowRecord record) {
        long traceId;
        if (record instanceof TraceMetadata) {
            traceId = ((TraceMetadata)record).getTraceId();
        } else if (record instanceof AbstractTraceEvent) {
            traceId = ((ITraceRecord)record).getTraceId();
        } else {
            return;
        }
        if (this.acceptId(traceId)) {
            super.deliver(OUTPUT_PORT_NAME_MATCH, record);
        } else {
            super.deliver(OUTPUT_PORT_NAME_MISMATCH, record);
        }
    }

    @InputPort(name="monitoringRecordsExecution", description="Receives execution events to be selected by trace ID", eventTypes={OperationExecutionRecord.class})
    public void inputOperationExecutionRecord(OperationExecutionRecord record) {
        if (this.acceptId(record.getTraceId())) {
            super.deliver(OUTPUT_PORT_NAME_MATCH, record);
        } else {
            super.deliver(OUTPUT_PORT_NAME_MISMATCH, record);
        }
    }
}

