/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.reader.AbstractReaderPlugin;
import kieker.analysis.plugin.reader.RegistryRecordHandler;
import kieker.analysis.plugin.reader.RegularRecordHandler;
import kieker.analysis.plugin.reader.StringRegistryCache;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;

@Deprecated
@Plugin
public abstract class AbstractStringRegistryReaderPlugin
extends AbstractReaderPlugin {
    private static final long DEFAULT_CACHE_EXPIRATION_DURATION = 1L;
    private static final TimeUnit DEFAULT_CACHE_EXPIRATION_TIME_UNIT = TimeUnit.MINUTES;
    private final StringRegistryCache stringRegistryLookup;
    private volatile boolean threadsStarted;
    private volatile Thread registryRecordHandlerThread;
    private volatile RegistryRecordHandler registryRecordHandler;
    private volatile RegularRecordHandler regularRecordHandler;
    private volatile Thread regularRecordHandlerThread;

    public AbstractStringRegistryReaderPlugin(Configuration configuration, IProjectContext projectContext) {
        this(configuration, projectContext, 1L, DEFAULT_CACHE_EXPIRATION_TIME_UNIT);
    }

    protected AbstractStringRegistryReaderPlugin(Configuration configuration, IProjectContext projectContext, String cacheDurationProperty, TimeUnit cacheDurationTimeUnit) {
        super(configuration, projectContext);
        long cacheExpirationDuration = configuration.getLongProperty(cacheDurationProperty);
        this.stringRegistryLookup = new StringRegistryCache(cacheExpirationDuration, cacheDurationTimeUnit);
    }

    private AbstractStringRegistryReaderPlugin(Configuration configuration, IProjectContext projectContext, long cacheExpirationDuration, TimeUnit cacheExpirationTimeUnit) {
        super(configuration, projectContext);
        this.stringRegistryLookup = this.createCache(cacheExpirationDuration, cacheExpirationTimeUnit);
    }

    @Override
    public boolean init() {
        boolean superInitSucceeded = super.init();
        if (!superInitSucceeded) {
            return false;
        }
        this.registryRecordHandler = new RegistryRecordHandler(this.stringRegistryLookup);
        this.regularRecordHandler = new RegularRecordHandler(this, this.stringRegistryLookup);
        this.registryRecordHandlerThread = new Thread(this.registryRecordHandler);
        this.registryRecordHandlerThread.setDaemon(true);
        this.regularRecordHandlerThread = new Thread(this.regularRecordHandler);
        this.regularRecordHandlerThread.setDaemon(true);
        return true;
    }

    protected StringRegistryCache createCache(long expirationDuration, TimeUnit expirationTimeUnit) {
        return new StringRegistryCache(expirationDuration, expirationTimeUnit);
    }

    protected final void ensureThreadsStarted() {
        if (!this.threadsStarted) {
            this.registryRecordHandlerThread.start();
            this.regularRecordHandlerThread.start();
            this.threadsStarted = true;
        }
    }

    protected void handleRegistryRecord(ByteBuffer buffer) {
        this.registryRecordHandler.enqueueRegistryRecord(buffer);
    }

    protected void handleRegularRecord(ByteBuffer buffer) {
        this.regularRecordHandler.enqueueRegularRecord(buffer);
    }

    protected abstract void deliverRecord(IMonitoringRecord var1);
}

