/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader.filesystem;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.zip.ZipInputStream;
import kieker.analysis.generic.source.file.MappingException;
import kieker.analysis.plugin.reader.filesystem.AbstractLogReaderThread;
import kieker.analysis.plugin.reader.filesystem.TextFileStreamProcessor;
import kieker.analysis.plugin.reader.util.IMonitoringRecordReceiver;
import kieker.common.exception.MonitoringRecordException;
import kieker.common.exception.UnknownRecordTypeException;
import kieker.common.registry.reader.ReaderRegistry;
import kieker.common.util.filesystem.FSUtil;
import kieker.common.util.filesystem.FileExtensionFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
class AsciiLogReaderThread
extends AbstractLogReaderThread {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsciiLogReaderThread.class);
    private final ReaderRegistry<String> stringRegistry = new ReaderRegistry();
    private final IMonitoringRecordReceiver recordReceiver;
    private final File inputDir;
    private final boolean shouldDecompress;
    private final TextFileStreamProcessor textFileStreamProcessor;

    public AsciiLogReaderThread(File inputDir, IMonitoringRecordReceiver recordReceiver, boolean ignoreUnknownRecordTypes, boolean shouldDecompress) {
        super(LOGGER, inputDir);
        if (inputDir == null || !inputDir.isDirectory()) {
            throw new IllegalArgumentException("Invalid or empty inputDir");
        }
        this.inputDir = inputDir;
        this.recordReceiver = recordReceiver;
        this.textFileStreamProcessor = new TextFileStreamProcessor(ignoreUnknownRecordTypes, this.stringRegistry, recordReceiver);
        this.shouldDecompress = shouldDecompress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readMappingFile() {
        File mappingFile = new File(this.inputDir.getAbsolutePath() + File.separator + "kieker.map");
        if (!mappingFile.exists()) {
            mappingFile = new File(this.inputDir.getAbsolutePath() + File.separator + "tpmon.map");
            if (mappingFile.exists()) {
                LOGGER.info("Directory '{}' contains no file '{}'. Found '{}' ... switching to legacy mode", new Object[]{this.inputDir, "kieker.map", "tpmon.map"});
            } else {
                LOGGER.warn("No mapping file in directory '{}'", (Object)this.inputDir.getAbsolutePath());
                return;
            }
        }
        BufferedReader in = null;
        try {
            String line;
            in = Files.newBufferedReader(mappingFile.toPath(), Charset.forName("UTF-8"));
            while ((line = in.readLine()) != null) {
                Integer id;
                int split;
                if (line.length() == 0) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Read line: " + line);
                }
                if ((split = line.indexOf(61)) == -1) {
                    LOGGER.error("Failed to parse line: {} from file {}. Each line must contain ID=VALUE pairs.", (Object)line, (Object)mappingFile.getAbsolutePath());
                    continue;
                }
                String key = line.substring(0, split);
                String value = FSUtil.decodeNewline(line.substring(split + 1));
                try {
                    id = Integer.valueOf(key.charAt(0) == '$' ? key.substring(1) : key);
                }
                catch (NumberFormatException ex) {
                    LOGGER.error("Error reading mapping file, id must be integer", (Throwable)ex);
                    continue;
                }
                String prevVal = this.stringRegistry.register(id.intValue(), value);
                if (prevVal == null) continue;
                LOGGER.error("Found addional entry for id='{}', old value was '{}' new value is '{}'", new Object[]{id, prevVal, value});
            }
        }
        catch (IOException ex) {
            LOGGER.error("Error reading mapping file", (Throwable)ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    LOGGER.error("Exception while closing input stream for mapping file", (Throwable)ex);
                }
            }
        }
    }

    @Override
    protected void processNormalInputFile(File inputFile) {
        try {
            InputStream fileInputStream = Files.newInputStream(inputFile.toPath(), StandardOpenOption.READ);
            if (this.shouldDecompress) {
                ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
                zipInputStream.getNextEntry();
                fileInputStream = zipInputStream;
            }
            this.textFileStreamProcessor.processInputChannel(fileInputStream);
        }
        catch (IOException e) {
            LOGGER.error("Error reading {} {}", (Object)inputFile, (Object)e);
        }
        catch (MappingException e) {
            LOGGER.error("Error reading {} {}", (Object)inputFile, (Object)e);
        }
        catch (MonitoringRecordException e) {
            LOGGER.error("Error reading {} {}", (Object)inputFile, (Object)e);
        }
        catch (UnknownRecordTypeException e) {
            LOGGER.error("Error reading {} {}", (Object)inputFile, (Object)e);
        }
    }

    @Override
    protected FileExtensionFilter getFileExtensionFilter() {
        return this.shouldDecompress ? FileExtensionFilter.ZIP : FileExtensionFilter.DAT;
    }

    @Override
    protected void onEndOfRun() {
        this.recordReceiver.newEndOfFileRecord();
    }
}

