/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader.filesystem;

import java.io.IOException;
import java.io.InputStream;
import java.nio.CharBuffer;
import kieker.analysis.generic.source.file.MappingException;
import kieker.analysis.plugin.reader.util.IMonitoringRecordReceiver;
import kieker.common.exception.MonitoringRecordException;
import kieker.common.exception.UnknownRecordTypeException;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.factory.CachedRecordFactoryCatalog;
import kieker.common.record.factory.IRecordFactory;
import kieker.common.record.io.TextValueDeserializer;
import kieker.common.registry.reader.ReaderRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class TextFileStreamProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextFileStreamProcessor.class);
    private static final int BUFFER_SIZE = 10240;
    private final boolean ignoreUnknownRecordTypes;
    private final CachedRecordFactoryCatalog recordFactories = CachedRecordFactoryCatalog.getInstance();
    private final CharBuffer charBuffer = CharBuffer.allocate(10240);
    private boolean terminated;
    private final IMonitoringRecordReceiver recordReceiver;
    private final ReaderRegistry<String> stringRegistry;

    public TextFileStreamProcessor(boolean ignoreUnknownRecordTypes, ReaderRegistry<String> stringRegistry, IMonitoringRecordReceiver recordReceiver) {
        this.ignoreUnknownRecordTypes = ignoreUnknownRecordTypes;
        this.recordReceiver = recordReceiver;
        this.terminated = false;
        this.stringRegistry = stringRegistry;
    }

    public void processInputChannel(InputStream inputStream) throws IOException, MappingException, MonitoringRecordException, UnknownRecordTypeException {
        byte[] buffer = new byte[10240];
        boolean endOfFile = false;
        int offset = 0;
        while (!endOfFile && !this.terminated) {
            int numOfReadBytes = inputStream.read(buffer, offset, 10240 - offset);
            if (numOfReadBytes == -1) {
                endOfFile = true;
                continue;
            }
            int numOfBufferedBytes = numOfReadBytes + offset;
            int mark = this.processBuffer(buffer, offset, numOfBufferedBytes);
            for (int j = mark + 1; j < numOfBufferedBytes; ++j) {
                buffer[j - mark - 1] = buffer[j];
            }
            offset = numOfBufferedBytes - mark;
        }
        if (this.charBuffer.position() > 0) {
            this.createRecord();
        }
    }

    private int processBuffer(byte[] buffer, int offset, int numOfBufferedBytes) throws MappingException, MonitoringRecordException, UnknownRecordTypeException {
        int mark = 0;
        for (int i = offset; i < numOfBufferedBytes; ++i) {
            char ch = (char)buffer[i];
            if (ch == '\n') {
                this.createRecord();
                mark = i;
                continue;
            }
            if (ch == '\r') {
                if (buffer[i + 1] == 10) {
                    // empty if block
                }
                this.createRecord();
                mark = ++i;
                continue;
            }
            this.charBuffer.append(ch);
        }
        return mark;
    }

    private void createRecord() throws MappingException, MonitoringRecordException, UnknownRecordTypeException {
        char lead;
        this.charBuffer.flip();
        if (this.charBuffer.hasRemaining() && (lead = this.charBuffer.get()) == '$') {
            TextValueDeserializer deserializer = TextValueDeserializer.create(this.charBuffer);
            int id = deserializer.getInt();
            String classname = this.stringRegistry.get(id);
            if (classname == null) {
                if (this.ignoreUnknownRecordTypes) {
                    return;
                }
                throw new MappingException("Missing classname mapping for record type id '" + id + "'");
            }
            long loggingTimestamp = deserializer.getLong();
            IRecordFactory<? extends IMonitoringRecord> recordFactory = this.recordFactories.get(classname);
            if (recordFactory != null) {
                try {
                    IMonitoringRecord event = recordFactory.create(deserializer);
                    event.setLoggingTimestamp(loggingTimestamp);
                    if (!this.recordReceiver.newMonitoringRecord(event)) {
                        this.terminated = true;
                    }
                }
                catch (NumberFormatException ex) {
                    LOGGER.error("Record of type {} format error.", (Object)classname);
                }
            } else {
                LOGGER.info("Record type {} unkown", (Object)classname);
            }
            this.charBuffer.clear();
        }
    }
}

