/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader.timer;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.reader.AbstractReaderPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.record.misc.TimestampRecord;

@Deprecated
@Plugin(description="Delivers the current (system) time in regular intervals", outputPorts={@OutputPort(name="timestamps", eventTypes={Long.class}), @OutputPort(name="timestampRecords", eventTypes={TimestampRecord.class})}, configuration={@Property(name="updateIntervalNS", defaultValue="1000000000", description="Determines the update interval in nano seconds."), @Property(name="delayNS", defaultValue="0", description="Determines the initial delay in nano seconds."), @Property(name="numberImpulses", defaultValue="0", description="Determines the number of impulses to emit (0 = infinite).")})
public final class TimeReader
extends AbstractReaderPlugin {
    public static final String OUTPUT_PORT_NAME_TIMESTAMPS = "timestamps";
    public static final String OUTPUT_PORT_NAME_TIMESTAMP_RECORDS = "timestampRecords";
    public static final String CONFIG_PROPERTY_NAME_UPDATE_INTERVAL_NS = "updateIntervalNS";
    public static final String CONFIG_PROPERTY_VALUE_UPDATE_INTERVAL_NS = "1000000000";
    public static final String CONFIG_PROPERTY_NAME_DELAY_NS = "delayNS";
    public static final String CONFIG_PROPERTY_VALUE_DELAY_NS = "0";
    public static final String CONFIG_PROPERTY_NAME_NUMBER_IMPULSES = "numberImpulses";
    public static final String CONFIG_PROPERTY_VALUE_NUMBER_IMPULSES = "0";
    public static final long INFINITE_EMITS = 0L;
    final CountDownLatch impulseEmitLatch = new CountDownLatch(1);
    private volatile boolean terminated;
    private final ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(1);
    private volatile ScheduledFuture<?> result;
    private final long initialDelay;
    private final long period;
    private final long numberImpulses;

    public TimeReader(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        this.initialDelay = configuration.getLongProperty(CONFIG_PROPERTY_NAME_DELAY_NS);
        this.period = configuration.getLongProperty(CONFIG_PROPERTY_NAME_UPDATE_INTERVAL_NS);
        this.numberImpulses = configuration.getLongProperty(CONFIG_PROPERTY_NAME_NUMBER_IMPULSES);
    }

    @Override
    public void terminate(boolean error) {
        if (!this.terminated) {
            this.logger.info("Shutdown of TimeReader requested.");
            this.executorService.shutdown();
            try {
                this.terminated = this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.terminated && this.result != null) {
                this.result.cancel(true);
            }
        }
    }

    @Override
    public boolean read() {
        this.result = this.executorService.scheduleAtFixedRate(new TimestampEventTask(this.numberImpulses), this.initialDelay, this.period, TimeUnit.NANOSECONDS);
        try {
            if (this.numberImpulses == 0L) {
                this.result.get();
            } else {
                this.impulseEmitLatch.await();
            }
        }
        catch (ExecutionException ex) {
            this.terminate(true);
            throw new RuntimeException(ex.getCause());
        }
        catch (InterruptedException interruptedException) {
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        this.terminate(false);
        return true;
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_DELAY_NS, Long.toString(this.initialDelay));
        configuration.setProperty(CONFIG_PROPERTY_NAME_UPDATE_INTERVAL_NS, Long.toString(this.period));
        configuration.setProperty(CONFIG_PROPERTY_NAME_NUMBER_IMPULSES, Long.toString(this.numberImpulses));
        return configuration;
    }

    protected void sendTimestampEvent() {
        long timestamp = this.recordsTimeUnitFromProjectContext.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
        super.deliver(OUTPUT_PORT_NAME_TIMESTAMPS, timestamp);
        super.deliver(OUTPUT_PORT_NAME_TIMESTAMP_RECORDS, new TimestampRecord(timestamp));
    }

    protected class TimestampEventTask
    implements Runnable {
        private final boolean infinite;
        private volatile long numberImpulses;

        public TimestampEventTask(long numberImpulses) {
            this.numberImpulses = numberImpulses;
            this.infinite = numberImpulses == 0L;
        }

        @Override
        public void run() {
            if (this.infinite || this.numberImpulses > 0L) {
                TimeReader.this.sendTimestampEvent();
                if (!this.infinite && 0L == --this.numberImpulses) {
                    TimeReader.this.impulseEmitLatch.countDown();
                }
            }
        }
    }
}

