/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.statistics;

import java.util.function.Function;
import kieker.analysis.statistics.StatisticsDecoratorStage;
import kieker.analysis.statistics.calculating.CountCalculator;
import kieker.analysis.statistics.calculating.MaxCalculator;
import kieker.analysis.statistics.calculating.MeanCalculator;
import kieker.analysis.statistics.calculating.MedianCalculator;
import kieker.analysis.statistics.calculating.MinCalculator;
import kieker.analysis.statistics.calculating.TotalCalculator;
import kieker.model.analysismodel.statistics.StatisticsModel;
import org.eclipse.emf.ecore.EObject;
import teetime.framework.CompositeStage;
import teetime.framework.InputPort;
import teetime.framework.OutputPort;

public class FullStatisticsDecoratorStage<T>
extends CompositeStage {
    private final StatisticsDecoratorStage<T> countStatistics;
    private final StatisticsDecoratorStage<T> medianStatistics;

    public FullStatisticsDecoratorStage(StatisticsModel statisticsModel, String property, Function<T, Long> valueAccessor, Function<T, EObject> objectAccesor) {
        this.countStatistics = new StatisticsDecoratorStage(statisticsModel, new CountCalculator("calls"), objectAccesor);
        StatisticsDecoratorStage<T> totalStatistics = new StatisticsDecoratorStage<T>(statisticsModel, new TotalCalculator<T>("total response time", valueAccessor), objectAccesor);
        StatisticsDecoratorStage<T> minStatistics = new StatisticsDecoratorStage<T>(statisticsModel, new MinCalculator<T>("min response time", valueAccessor), objectAccesor);
        StatisticsDecoratorStage<T> maxStatistics = new StatisticsDecoratorStage<T>(statisticsModel, new MaxCalculator<T>("max response time", valueAccessor), objectAccesor);
        StatisticsDecoratorStage averageStatistics = new StatisticsDecoratorStage(statisticsModel, new MeanCalculator("mean response time", "total response time", "calls"), objectAccesor);
        this.medianStatistics = new StatisticsDecoratorStage<T>(statisticsModel, new MedianCalculator<T>("median response time", valueAccessor), objectAccesor);
        super.connectPorts(this.countStatistics.getOutputPort(), totalStatistics.getInputPort());
        super.connectPorts(totalStatistics.getOutputPort(), minStatistics.getInputPort());
        super.connectPorts(minStatistics.getOutputPort(), maxStatistics.getInputPort());
        super.connectPorts(maxStatistics.getOutputPort(), averageStatistics.getInputPort());
        super.connectPorts(averageStatistics.getOutputPort(), this.medianStatistics.getInputPort());
    }

    public InputPort<T> getInputPort() {
        return this.countStatistics.getInputPort();
    }

    public OutputPort<T> getOutputPort() {
        return this.medianStatistics.getOutputPort();
    }
}

