/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.statistics;

import java.util.function.Function;
import kieker.analysis.statistics.calculating.AbstractCalculator;
import kieker.model.analysismodel.statistics.StatisticRecord;
import kieker.model.analysismodel.statistics.StatisticsFactory;
import kieker.model.analysismodel.statistics.StatisticsModel;
import org.eclipse.emf.ecore.EObject;

public class StatisticsDecorator<T> {
    private final StatisticsModel statisticsModel;
    private final AbstractCalculator<T> statisticCalculator;
    private final Function<T, EObject> objectAccesor;

    public StatisticsDecorator(StatisticsModel statisticsModel, AbstractCalculator<T> statisticCalculator, Function<T, EObject> objectAccesor) {
        this.statisticsModel = statisticsModel;
        this.statisticCalculator = statisticCalculator;
        this.objectAccesor = objectAccesor;
    }

    public void decorate(T input) {
        EObject object = this.objectAccesor.apply(input);
        StatisticRecord statistic = (StatisticRecord)this.statisticsModel.getStatistics().get((Object)object);
        if (statistic == null) {
            this.statisticsModel.getStatistics().put((Object)object, (Object)StatisticsFactory.eINSTANCE.createStatisticRecord());
            statistic = (StatisticRecord)this.statisticsModel.getStatistics().get((Object)object);
        }
        this.statisticCalculator.calculate(statistic, input, object);
    }
}

