/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.statistics.calculating;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import kieker.analysis.statistics.calculating.AbstractCalculator;
import kieker.analysis.util.RunningMedian;
import kieker.model.analysismodel.statistics.StatisticRecord;
import org.eclipse.emf.ecore.EObject;

public class MedianCalculator<T>
extends AbstractCalculator<T> {
    private final Map<EObject, RunningMedian<Long>> runningMedians = new HashMap<EObject, RunningMedian<Long>>();
    private final Function<T, Long> valueAccessor;

    public MedianCalculator(String propertyName, Function<T, Long> valueAccessor) {
        super(propertyName);
        this.valueAccessor = valueAccessor;
    }

    @Override
    public void calculate(StatisticRecord statistic, T input, EObject modelObject) {
        RunningMedian runningMedian = this.runningMedians.computeIfAbsent(modelObject, o -> RunningMedian.forLong());
        runningMedian.add(this.valueAccessor.apply(input));
        long newMedian = (Long)runningMedian.getMedian();
        statistic.getProperties().put((Object)this.getPropertyName(), (Object)newMedian);
    }
}

