/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.util;

import kieker.analysis.generic.depcompression.AbstractDecompressionFilter;
import kieker.analysis.generic.depcompression.DeflateDecompressionFilter;
import kieker.analysis.generic.depcompression.GZipDecompressionFilter;
import kieker.analysis.generic.depcompression.NoneDecompressionFilter;
import kieker.analysis.generic.depcompression.XZDecompressionFilter;
import kieker.analysis.generic.depcompression.ZipDecompressionFilter;
import kieker.analysis.generic.source.file.AbstractEventDeserializer;
import kieker.analysis.generic.source.file.AbstractMapDeserializer;
import kieker.analysis.generic.source.file.BinaryEventDeserializer;
import kieker.analysis.generic.source.file.DatEventDeserializer;
import kieker.analysis.generic.source.file.TextMapDeserializer;

public final class FSReaderUtil {
    private FSReaderUtil() {
    }

    public static String getExtension(String name) {
        int suffixStartPosition = name.lastIndexOf(46);
        if (suffixStartPosition == -1) {
            return null;
        }
        return name.substring(suffixStartPosition);
    }

    public static Class<? extends AbstractDecompressionFilter> findDecompressionFilterByExtension(String name) {
        String extension = FSReaderUtil.getExtension(name);
        if (".gz".equals(extension)) {
            return GZipDecompressionFilter.class;
        }
        if (".df".equals(extension)) {
            return DeflateDecompressionFilter.class;
        }
        if (".xz".equals(extension)) {
            return XZDecompressionFilter.class;
        }
        if (".zip".equals(extension)) {
            return ZipDecompressionFilter.class;
        }
        return NoneDecompressionFilter.class;
    }

    public static boolean hasValidFileExtension(String name) {
        String extension = FSReaderUtil.getExtension(name);
        if (".bin".equals(extension) || ".dat".equals(extension)) {
            return true;
        }
        return !FSReaderUtil.findDecompressionFilterByExtension(name).equals(NoneDecompressionFilter.class);
    }

    public static Class<? extends AbstractEventDeserializer> findEventDeserializer(String logFileName) {
        String extension = FSReaderUtil.getExtension(logFileName);
        if (".dat".equals(extension)) {
            return DatEventDeserializer.class;
        }
        if (".bin".equals(extension)) {
            return BinaryEventDeserializer.class;
        }
        return null;
    }

    public static Class<? extends AbstractMapDeserializer> findMapDeserializer(String mapFileName) {
        String extension = FSReaderUtil.getExtension(mapFileName);
        if (".map".equals(extension)) {
            return TextMapDeserializer.class;
        }
        return null;
    }
}

