/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.util;

import kieker.model.analysismodel.assembly.AssemblyComponent;
import kieker.model.analysismodel.assembly.AssemblyModel;
import kieker.model.analysismodel.assembly.AssemblyOperation;
import kieker.model.analysismodel.assembly.AssemblyStorage;
import kieker.model.analysismodel.deployment.DeployedComponent;
import kieker.model.analysismodel.deployment.DeployedOperation;
import kieker.model.analysismodel.deployment.DeploymentContext;
import kieker.model.analysismodel.trace.OperationCall;
import kieker.model.analysismodel.type.ComponentType;
import kieker.model.analysismodel.type.OperationType;

public final class FullyQualifiedNamesFactory {
    private FullyQualifiedNamesFactory() {
    }

    public static String createFullyQualifiedName(DeployedOperation operation) {
        return String.format("%s.%s", FullyQualifiedNamesFactory.createFullyQualifiedName(operation.getComponent()), operation.getAssemblyOperation().getOperationType().getSignature());
    }

    public static String createFullyQualifiedName(DeployedComponent component) {
        return String.format("%s@%s_%d", component.getContext().getName(), FullyQualifiedNamesFactory.createFullyQualifiedName(component.getAssemblyComponent()), FullyQualifiedNamesFactory.findIndexNumber(component));
    }

    public static String createFullyQualifiedName(DeploymentContext context) {
        return context.getName();
    }

    public static String createFullyQualifiedName(AssemblyOperation operation) {
        return String.format("%s.%s", FullyQualifiedNamesFactory.createFullyQualifiedName(operation.getComponent()), operation.getOperationType().getSignature());
    }

    public static String createFullyQualifiedName(AssemblyStorage storage) {
        return String.format("%s.%s", FullyQualifiedNamesFactory.createFullyQualifiedName(storage.getComponent()), storage.getStorageType().getName());
    }

    public static String createFullyQualifiedName(AssemblyComponent component) {
        return String.format("%s_%d", component.getComponentType().getSignature(), FullyQualifiedNamesFactory.findIndexNumber(component));
    }

    public static int findIndexNumber(AssemblyComponent component) {
        boolean numberOfComponent = false;
        for (AssemblyComponent value : ((AssemblyModel)component.eContainer().eContainer()).getComponents().values()) {
            if (!value.equals(component)) continue;
            return 0;
        }
        return -1;
    }

    public static int findIndexNumber(DeployedComponent component) {
        boolean numberOfComponent = false;
        for (DeployedComponent value : component.getContext().getComponents().values()) {
            if (!value.equals(component)) continue;
            return 0;
        }
        return -1;
    }

    public static String createFullyQualifiedName(ComponentType component) {
        return component.getSignature();
    }

    public static String createFullyQualifiedName(OperationType operation) {
        return String.format("%s.%s", FullyQualifiedNamesFactory.createFullyQualifiedName(operation.getComponentType()), operation.getSignature());
    }

    public static String createFullyQualifiedName(OperationCall operationCall) {
        return String.format("%s_%d", FullyQualifiedNamesFactory.createFullyQualifiedName(operationCall.getOperation()), operationCall.getOrderIndex());
    }
}

