/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.util.debug;

import com.google.common.graph.EndpointPair;
import java.io.PrintStream;
import kieker.analysis.generic.graph.IEdge;
import kieker.analysis.generic.graph.IGraph;
import kieker.analysis.generic.graph.INode;
import teetime.framework.AbstractConsumerStage;

public class GraphPrinterStage<N extends INode, E extends IEdge>
extends AbstractConsumerStage<IGraph<N, E>> {
    private final PrintStream printStream;

    public GraphPrinterStage() {
        this(System.out);
    }

    public GraphPrinterStage(PrintStream printStream) {
        this.printStream = printStream;
    }

    protected void execute(IGraph<N, E> graph) {
        this.printGraph(graph, "");
    }

    private void printGraph(IGraph<N, E> graph, String offset) {
        this.printStream.printf("%sGraph %s Vertices:\n", graph.getLabel(), offset);
        for (INode node : graph.getGraph().nodes()) {
            this.printStream.printf("%s%s\n", offset, node.getId());
            if (node.getChildGraph() == null) continue;
            this.printGraph(node.getChildGraph(), "   " + offset);
        }
        this.printStream.printf("%sEdges:\n", offset);
        for (IEdge edge : graph.getGraph().edges()) {
            String targetLabel;
            String sourceLabel;
            EndpointPair nodePair = graph.getGraph().incidentNodes((Object)edge);
            if (graph.getGraph().isDirected()) {
                sourceLabel = ((INode)nodePair.source()).getId();
                targetLabel = ((INode)nodePair.target()).getId();
            } else {
                sourceLabel = ((INode)nodePair.nodeU()).getId();
                targetLabel = ((INode)nodePair.nodeV()).getId();
            }
            this.printStream.printf("%s -> %s\n", sourceLabel, targetLabel);
        }
    }
}

