/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.util.debug;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import teetime.framework.AbstractConsumerStage;
import teetime.framework.OutputPort;

public class ListCollectionFilter<T>
extends AbstractConsumerStage<T> {
    private final OutputPort<T> outputPort = this.createOutputPort();
    private final LinkedList<T> list;
    private final int maxNumberOfEntries;
    private final boolean unboundedList;
    private final ListFullBehavior listFullBehavior;

    public ListCollectionFilter(int maxNumberOfEntries, ListFullBehavior listFullBehavior) {
        this.maxNumberOfEntries = maxNumberOfEntries;
        this.unboundedList = this.maxNumberOfEntries < 0;
        this.listFullBehavior = listFullBehavior;
        this.list = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(T data) throws Exception {
        if (this.unboundedList) {
            LinkedList<T> linkedList = this.list;
            synchronized (linkedList) {
                this.list.add(data);
            }
        } else {
            switch (this.listFullBehavior) {
                case DROP_OLDEST: {
                    LinkedList<T> linkedList = this.list;
                    synchronized (linkedList) {
                        this.list.add(data);
                        if (this.list.size() > this.maxNumberOfEntries) {
                            this.list.removeFirst();
                        }
                        break;
                    }
                }
                case IGNORE: {
                    LinkedList<T> linkedList = this.list;
                    synchronized (linkedList) {
                        if (this.maxNumberOfEntries > this.list.size()) {
                            this.list.add(data);
                        }
                        break;
                    }
                }
                case ERROR: {
                    LinkedList<T> linkedList = this.list;
                    synchronized (linkedList) {
                        if (this.maxNumberOfEntries <= this.list.size()) {
                            throw new RuntimeException("Too many records for ListCollectionFilter, it was initialized with capacity: " + this.maxNumberOfEntries);
                        }
                        this.list.add(data);
                        break;
                    }
                }
            }
        }
        this.outputPort.send(data);
    }

    public OutputPort<T> getOutputPort() {
        return this.outputPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedList<T> linkedList = this.list;
        synchronized (linkedList) {
            this.list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getList() {
        LinkedList<T> linkedList = this.list;
        synchronized (linkedList) {
            return new CopyOnWriteArrayList<T>(this.list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        LinkedList<T> linkedList = this.list;
        synchronized (linkedList) {
            return this.list.size();
        }
    }

    public static enum ListFullBehavior {
        DROP_OLDEST,
        IGNORE,
        ERROR;

    }
}

