/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.util.debug.hotspotdetection;

import java.io.File;
import java.time.temporal.ChronoUnit;
import kieker.analysis.architecture.recovery.ModelAssemblerStage;
import kieker.analysis.architecture.recovery.OperationAndCallGeneratorStage;
import kieker.analysis.architecture.recovery.assembler.OperationAssemblyModelAssembler;
import kieker.analysis.architecture.recovery.assembler.OperationDeploymentModelAssembler;
import kieker.analysis.architecture.recovery.assembler.OperationTypeModelAssembler;
import kieker.analysis.architecture.recovery.events.OperationEvent;
import kieker.analysis.architecture.recovery.signature.JavaComponentSignatureExtractor;
import kieker.analysis.architecture.recovery.signature.JavaOperationSignatureExtractor;
import kieker.analysis.architecture.trace.flow.FlowTraceEventMatcher;
import kieker.analysis.architecture.trace.reconstruction.FlowRecordTraceReconstructionStage;
import kieker.analysis.generic.ControlledEventReleaseStage;
import kieker.analysis.generic.source.file.DirectoryReaderStage;
import kieker.analysis.generic.source.file.KiekerDirectoryScannerStage;
import kieker.analysis.util.debug.hotspotdetection.HotspotDetectionStage;
import kieker.common.record.flow.IFlowRecord;
import kieker.model.analysismodel.assembly.AssemblyFactory;
import kieker.model.analysismodel.assembly.AssemblyModel;
import kieker.model.analysismodel.deployment.DeploymentFactory;
import kieker.model.analysismodel.deployment.DeploymentModel;
import kieker.model.analysismodel.source.SourceFactory;
import kieker.model.analysismodel.source.SourceModel;
import kieker.model.analysismodel.type.TypeFactory;
import kieker.model.analysismodel.type.TypeModel;
import teetime.framework.Configuration;
import teetime.stage.InstanceOfFilter;
import teetime.stage.basic.distributor.Distributor;

public class HotspotDetectionConfiguration
extends Configuration {
    private static final String DYNAMIC_SOURCE = null;

    public HotspotDetectionConfiguration(File importDirectory) {
        TypeModel typeModel = TypeFactory.eINSTANCE.createTypeModel();
        AssemblyModel assemblyModel = AssemblyFactory.eINSTANCE.createAssemblyModel();
        DeploymentModel deploymentModel = DeploymentFactory.eINSTANCE.createDeploymentModel();
        SourceModel sourceModel = SourceFactory.eINSTANCE.createSourceModel();
        KiekerDirectoryScannerStage directoryScannerStage = new KiekerDirectoryScannerStage(importDirectory);
        DirectoryReaderStage directoryReaderStage = new DirectoryReaderStage(false, 80860);
        InstanceOfFilter instanceOfFilter = new InstanceOfFilter(IFlowRecord.class);
        Distributor flowRecordDistributor = new Distributor();
        OperationAndCallGeneratorStage operationAndCallGeneratorStage = new OperationAndCallGeneratorStage(true);
        ModelAssemblerStage<OperationEvent> typeModelAssembler = new ModelAssemblerStage<OperationEvent>(new OperationTypeModelAssembler(typeModel, sourceModel, DYNAMIC_SOURCE, new JavaComponentSignatureExtractor(), new JavaOperationSignatureExtractor()));
        ModelAssemblerStage<OperationEvent> assemblyModelAssembler = new ModelAssemblerStage<OperationEvent>(new OperationAssemblyModelAssembler(typeModel, assemblyModel, sourceModel, DYNAMIC_SOURCE));
        ModelAssemblerStage<OperationEvent> deploymentModelAssemblerStage = new ModelAssemblerStage<OperationEvent>(new OperationDeploymentModelAssembler(assemblyModel, deploymentModel, sourceModel, DYNAMIC_SOURCE));
        ControlledEventReleaseStage<OperationEvent, IFlowRecord> flowRecordMerger = new ControlledEventReleaseStage<OperationEvent, IFlowRecord>(new FlowTraceEventMatcher());
        FlowRecordTraceReconstructionStage traceReconstructor = new FlowRecordTraceReconstructionStage(deploymentModel, ChronoUnit.NANOS);
        HotspotDetectionStage hotspotDetector = new HotspotDetectionStage();
        super.connectPorts(directoryScannerStage.getOutputPort(), directoryReaderStage.getInputPort());
        super.connectPorts(directoryReaderStage.getOutputPort(), instanceOfFilter.getInputPort());
        super.connectPorts(instanceOfFilter.getMatchedOutputPort(), flowRecordDistributor.getInputPort());
        super.connectPorts(flowRecordDistributor.getNewOutputPort(), operationAndCallGeneratorStage.getInputPort());
        super.connectPorts(operationAndCallGeneratorStage.getOperationOutputPort(), typeModelAssembler.getInputPort());
        super.connectPorts(typeModelAssembler.getOutputPort(), assemblyModelAssembler.getInputPort());
        super.connectPorts(assemblyModelAssembler.getOutputPort(), deploymentModelAssemblerStage.getInputPort());
        super.connectPorts(deploymentModelAssemblerStage.getOutputPort(), flowRecordMerger.getControlInputPort());
        super.connectPorts(flowRecordDistributor.getNewOutputPort(), flowRecordMerger.getBaseInputPort());
        super.connectPorts(flowRecordMerger.getOutputPort(), traceReconstructor.getInputPort());
        super.connectPorts(traceReconstructor.getOutputPort(), hotspotDetector.getInputPort());
    }
}

