/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.util.debug.hotspotdetection;

import java.io.PrintStream;
import java.time.Duration;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import kieker.analysis.architecture.trace.traversal.IOperationCallVisitor;
import kieker.analysis.architecture.trace.traversal.TraceTraverser;
import kieker.model.analysismodel.trace.OperationCall;
import kieker.model.analysismodel.trace.Trace;
import teetime.framework.AbstractConsumerStage;

public class HotspotDetectionStage
extends AbstractConsumerStage<Trace> {
    private static final int DEFAULT_MAX_OUTPUT = 10;
    private static final PrintStream DEFAULT_PRINT_STREAM = System.out;
    private final Map<OperationCall, Duration> durationsWithoutChild = new HashMap<OperationCall, Duration>();
    private final TraceTraverser traceTraverser = new TraceTraverser();
    private final int maxOutput;
    private final PrintStream printStream;

    public HotspotDetectionStage() {
        this.maxOutput = 10;
        this.printStream = DEFAULT_PRINT_STREAM;
    }

    public HotspotDetectionStage(int maxOutput, PrintStream printStream) {
        this.maxOutput = maxOutput;
        this.printStream = printStream;
    }

    protected void execute(Trace trace) {
        DurationCollector visitor = new DurationCollector(this.durationsWithoutChild);
        this.traceTraverser.traverse(trace, visitor);
    }

    protected void onTerminating() {
        this.printHotspots();
        super.onTerminating();
    }

    private void printHotspots() {
        Map<OperationCall, Duration> sortedMap = HotspotDetectionStage.sortMapByValue(this.durationsWithoutChild);
        sortedMap.entrySet().stream().limit(this.maxOutput).map(e -> ((OperationCall)e.getKey()).getOperation().getComponent().getAssemblyComponent().getComponentType().getSignature() + " " + ((OperationCall)e.getKey()).getOperation().getAssemblyOperation().getOperationType().getSignature() + ": " + ((Duration)e.getValue()).toString()).forEach(this.printStream::println);
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortMapByValue(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return ((Comparable)o2.getValue()).compareTo(o1.getValue());
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), (Comparable)entry.getValue());
        }
        return result;
    }

    private static class DurationCollector
    implements IOperationCallVisitor {
        private final Map<OperationCall, Duration> durationsWithoutChild;

        DurationCollector(Map<OperationCall, Duration> durationsWithoutChild) {
            this.durationsWithoutChild = durationsWithoutChild;
        }

        @Override
        public void visit(OperationCall operationCall) {
            Duration duration = operationCall.getDuration();
            Duration durationsOfChildren = operationCall.getChildren().stream().map(c -> c.getDuration()).reduce(Duration.ZERO, (r, d) -> r.plus((Duration)d));
            Duration durationWithoutChildren = duration.minus(durationsOfChildren);
            this.durationsWithoutChild.put(operationCall, durationWithoutChildren);
        }
    }
}

