/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.util.timeseries;

import java.time.Duration;
import java.time.Instant;
import kieker.analysis.util.timeseries.ITimeSeriesPoint;
import kieker.analysis.util.timeseries.TimeSeries;

public class BoundedTimeSeries<T extends ITimeSeriesPoint>
extends TimeSeries<T> {
    private final Duration capacity;

    public BoundedTimeSeries(Duration capacity) {
        this.capacity = capacity;
    }

    public BoundedTimeSeries(Duration capacity, TimeSeries<T> timeSeries) {
        super(timeSeries);
        this.capacity = capacity;
        this.removeOverflow();
    }

    public BoundedTimeSeries(BoundedTimeSeries<T> timeSeries) {
        super(timeSeries);
        this.capacity = timeSeries.getCapacity();
    }

    @Override
    public void appendBegin(T timeSeriesPoint) {
        super.appendBegin(timeSeriesPoint);
        this.removeOverflow();
    }

    @Override
    public void appendEnd(T timeSeriesPoint) {
        super.appendEnd(timeSeriesPoint);
        this.removeOverflow();
    }

    public Duration getCapacity() {
        return this.capacity;
    }

    private void removeOverflow() {
        if (this.size() == 0) {
            return;
        }
        Instant limit = super.getEnd().getTime().minus(this.capacity);
        while (this.size() > 0 && super.getBegin().getTime().isBefore(limit)) {
            super.removeBegin();
        }
    }
}

