/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.factory.IRecordFactory;
import kieker.common.record.factory.IRecordFactoryProvider;
import kieker.common.record.factory.RecordFactory;
import kieker.common.record.factory.StandardRecordFactoryProvider;

public class RecordFactoryResolver {
    private final List<IRecordFactoryProvider> factoryProviders;
    private final IRecordFactoryProvider defaultFactoryProvider = new StandardRecordFactoryProvider();

    public RecordFactoryResolver() {
        this(ServiceLoader.load(IRecordFactoryProvider.class));
    }

    public RecordFactoryResolver(Iterable<IRecordFactoryProvider> factoryProviders) {
        this.factoryProviders = StreamSupport.stream(factoryProviders.spliterator(), false).collect(Collectors.toList());
    }

    public IRecordFactory<? extends IMonitoringRecord> get(String recordClassName) {
        try {
            Class<?> recordClass = Class.forName(recordClassName);
            RecordFactory factoryAnnotation = recordClass.getAnnotation(RecordFactory.class);
            if (factoryAnnotation != null) {
                Class<? extends IRecordFactory<?>> factoryClass = factoryAnnotation.value();
                return this.createFactory(factoryClass);
            }
            IRecordFactoryProvider factoryProvider = this.determineProviderFor(recordClass);
            return factoryProvider.createFactoryFor(recordClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private IRecordFactoryProvider determineProviderFor(Class<?> recordClass) {
        Optional<IRecordFactoryProvider> applicableProvider = this.factoryProviders.stream().filter(provider -> provider.isApplicableTo(recordClass)).findFirst();
        return applicableProvider.orElse(this.defaultFactoryProvider);
    }

    private IRecordFactory createFactory(Class<?> providerClass) {
        try {
            Constructor<?> constructor = providerClass.getConstructor(new Class[0]);
            return (IRecordFactory)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }
}

