/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import kieker.common.record.factory.IRecordFactory;
import kieker.common.record.factory.IRecordFactoryProvider;
import kieker.common.util.classpath.ClassForNameResolver;

public class StandardRecordFactoryProvider
implements IRecordFactoryProvider {
    private final ClassForNameResolver<IRecordFactory> classForNameResolver = new ClassForNameResolver<IRecordFactory>(IRecordFactory.class);

    @Override
    public boolean isApplicableTo(Class<?> recordClass) {
        return true;
    }

    private String buildRecordFactoryClassName(String recordClassName) {
        return recordClassName + "Factory";
    }

    @Override
    public IRecordFactory<?> createFactoryFor(Class<?> recordClass) {
        String recordFactoryClassName = this.buildRecordFactoryClassName(recordClass.getName());
        try {
            Class<IRecordFactory> recordFactoryClass = this.classForNameResolver.classForName(recordFactoryClassName);
            Constructor<IRecordFactory> defaultConstructor = recordFactoryClass.getConstructor(new Class[0]);
            return defaultConstructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }
}

