/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.trace;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;

public class BeforeSentRemoteEvent
extends AbstractMonitoringRecord {
    public static final int SIZE = 24;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, String.class};
    public static final String[] VALUE_NAMES = new String[]{"timestamp", "traceId", "orderIndex", "technology"};
    public static final long TIMESTAMP = -1L;
    public static final long TRACE_ID = -1L;
    public static final int ORDER_INDEX = -1;
    public static final String TECHNOLOGY = "<default-technology>";
    private static final long serialVersionUID = 1817999525650163947L;
    private final long timestamp;
    private final long traceId;
    private final int orderIndex;
    private final String technology;

    public BeforeSentRemoteEvent(long timestamp, long traceId, int orderIndex, String technology) {
        this.timestamp = timestamp;
        this.traceId = traceId;
        this.orderIndex = orderIndex;
        this.technology = technology == null ? TECHNOLOGY : technology;
    }

    public BeforeSentRemoteEvent(IValueDeserializer deserializer) throws RecordInstantiationException {
        this.timestamp = deserializer.getLong();
        this.traceId = deserializer.getLong();
        this.orderIndex = deserializer.getInt();
        this.technology = deserializer.getString();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
        serializer.putLong(this.getTraceId());
        serializer.putInt(this.getOrderIndex());
        serializer.putString(this.getTechnology());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 24;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        BeforeSentRemoteEvent castedRecord = (BeforeSentRemoteEvent)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp() || this.getTimestamp() != castedRecord.getTimestamp() || this.getTraceId() != castedRecord.getTraceId() || this.getOrderIndex() != castedRecord.getOrderIndex()) {
            return false;
        }
        return this.getTechnology().equals(castedRecord.getTechnology());
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += (int)this.getTraceId();
        code += this.getOrderIndex();
        return code += this.getTechnology().hashCode();
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final long getTraceId() {
        return this.traceId;
    }

    public final int getOrderIndex() {
        return this.orderIndex;
    }

    public final String getTechnology() {
        return this.technology;
    }

    @Override
    public String toString() {
        Object result = "BeforeSentRemoteEvent: ";
        result = (String)result + "timestamp = ";
        result = (String)result + this.getTimestamp() + ", ";
        result = (String)result + "traceId = ";
        result = (String)result + this.getTraceId() + ", ";
        result = (String)result + "orderIndex = ";
        result = (String)result + this.getOrderIndex() + ", ";
        result = (String)result + "technology = ";
        result = (String)result + this.getTechnology() + ", ";
        return result;
    }
}

