/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.trace.operation;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.flow.trace.operation.BeforeOperationEvent;
import kieker.common.record.flow.trace.operation.IPayloadCharacterization;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;

public class EntryLevelBeforeOperationEvent
extends BeforeOperationEvent
implements IPayloadCharacterization {
    public static final int SIZE = 40;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, String.class, String.class, String[].class, String[].class, Integer.TYPE};
    public static final String[] VALUE_NAMES = new String[]{"timestamp", "traceId", "orderIndex", "operationSignature", "classSignature", "parameters", "values", "requestType"};
    private static final long serialVersionUID = -5792998777554640602L;
    private final String[] parameters;
    private final String[] values;
    private final int requestType;

    public EntryLevelBeforeOperationEvent(long timestamp, long traceId, int orderIndex, String operationSignature, String classSignature, String[] parameters, String[] values, int requestType) {
        super(timestamp, traceId, orderIndex, operationSignature, classSignature);
        this.parameters = parameters;
        this.values = values;
        this.requestType = requestType;
    }

    public EntryLevelBeforeOperationEvent(IValueDeserializer deserializer) throws RecordInstantiationException {
        super(deserializer);
        int _parameters_size0 = deserializer.getInt();
        this.parameters = new String[_parameters_size0];
        for (int i0 = 0; i0 < _parameters_size0; ++i0) {
            this.parameters[i0] = deserializer.getString();
        }
        int _values_size0 = deserializer.getInt();
        this.values = new String[_values_size0];
        for (int i0 = 0; i0 < _values_size0; ++i0) {
            this.values[i0] = deserializer.getString();
        }
        this.requestType = deserializer.getInt();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
        serializer.putLong(this.getTraceId());
        serializer.putInt(this.getOrderIndex());
        serializer.putString(this.getOperationSignature());
        serializer.putString(this.getClassSignature());
        int _parameters_size0 = this.getParameters().length;
        serializer.putInt(_parameters_size0);
        for (int i0 = 0; i0 < _parameters_size0; ++i0) {
            serializer.putString(this.getParameters()[i0]);
        }
        int _values_size0 = this.getValues().length;
        serializer.putInt(_values_size0);
        for (int i0 = 0; i0 < _values_size0; ++i0) {
            serializer.putString(this.getValues()[i0]);
        }
        serializer.putInt(this.getRequestType());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 40;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        EntryLevelBeforeOperationEvent castedRecord = (EntryLevelBeforeOperationEvent)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp() || this.getTimestamp() != castedRecord.getTimestamp() || this.getTraceId() != castedRecord.getTraceId() || this.getOrderIndex() != castedRecord.getOrderIndex()) {
            return false;
        }
        if (!this.getOperationSignature().equals(castedRecord.getOperationSignature())) {
            return false;
        }
        if (!this.getClassSignature().equals(castedRecord.getClassSignature())) {
            return false;
        }
        int _parameters_size0 = this.getParameters().length;
        if (_parameters_size0 != castedRecord.getParameters().length) {
            return false;
        }
        for (int i0 = 0; i0 < _parameters_size0; ++i0) {
            if (this.getParameters()[i0].equals(castedRecord.getParameters()[i0])) continue;
            return false;
        }
        int _values_size0 = this.getValues().length;
        if (_values_size0 != castedRecord.getValues().length) {
            return false;
        }
        for (int i0 = 0; i0 < _values_size0; ++i0) {
            if (this.getValues()[i0].equals(castedRecord.getValues()[i0])) continue;
            return false;
        }
        return this.getRequestType() == castedRecord.getRequestType();
    }

    @Override
    public int hashCode() {
        int i1;
        int i0;
        int code = 0;
        code += (int)this.getTimestamp();
        code += (int)this.getTraceId();
        code += this.getOrderIndex();
        code += this.getOperationSignature().hashCode();
        code += this.getClassSignature().hashCode();
        for (i0 = 0; i0 < this.parameters.length; ++i0) {
            for (i1 = 0; i1 < this.parameters.length; ++i1) {
                code += this.getParameters()[i0].hashCode();
            }
        }
        for (i0 = 0; i0 < this.values.length; ++i0) {
            for (i1 = 0; i1 < this.values.length; ++i1) {
                code += this.getValues()[i0].hashCode();
            }
        }
        return code += this.getRequestType();
    }

    @Override
    public final String[] getParameters() {
        return this.parameters;
    }

    @Override
    public final String[] getValues() {
        return this.values;
    }

    @Override
    public final int getRequestType() {
        return this.requestType;
    }

    @Override
    public String toString() {
        Object result = "EntryLevelBeforeOperationEvent: ";
        result = (String)result + "timestamp = ";
        result = (String)result + this.getTimestamp() + ", ";
        result = (String)result + "traceId = ";
        result = (String)result + this.getTraceId() + ", ";
        result = (String)result + "orderIndex = ";
        result = (String)result + this.getOrderIndex() + ", ";
        result = (String)result + "operationSignature = ";
        result = (String)result + this.getOperationSignature() + ", ";
        result = (String)result + "classSignature = ";
        result = (String)result + this.getClassSignature() + ", ";
        result = (String)result + "parameters = ";
        int _parameters_size0 = this.getParameters().length;
        result = (String)result + "{ ";
        for (int i0 = 0; i0 < _parameters_size0; ++i0) {
            result = (String)result + this.getParameters()[i0] + ", ";
        }
        result = (String)result + " }";
        result = (String)result + "values = ";
        int _values_size0 = this.getValues().length;
        result = (String)result + "{ ";
        for (int i0 = 0; i0 < _values_size0; ++i0) {
            result = (String)result + this.getValues()[i0] + ", ";
        }
        result = (String)result + " }";
        result = (String)result + "requestType = ";
        result = (String)result + this.getRequestType() + ", ";
        return result;
    }
}

