/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.trace.operation.constructor;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.flow.IConstructorRecord;
import kieker.common.record.flow.trace.operation.CallOperationEvent;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;

public class CallConstructorEvent
extends CallOperationEvent
implements IConstructorRecord {
    public static final int SIZE = 36;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, String.class, String.class, String.class, String.class};
    public static final String[] VALUE_NAMES = new String[]{"timestamp", "traceId", "orderIndex", "operationSignature", "classSignature", "calleeOperationSignature", "calleeClassSignature"};
    private static final long serialVersionUID = 9163096253392108958L;

    public CallConstructorEvent(long timestamp, long traceId, int orderIndex, String operationSignature, String classSignature, String calleeOperationSignature, String calleeClassSignature) {
        super(timestamp, traceId, orderIndex, operationSignature, classSignature, calleeOperationSignature, calleeClassSignature);
    }

    public CallConstructorEvent(IValueDeserializer deserializer) throws RecordInstantiationException {
        super(deserializer);
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
        serializer.putLong(this.getTraceId());
        serializer.putInt(this.getOrderIndex());
        serializer.putString(this.getOperationSignature());
        serializer.putString(this.getClassSignature());
        serializer.putString(this.getCalleeOperationSignature());
        serializer.putString(this.getCalleeClassSignature());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 36;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        CallConstructorEvent castedRecord = (CallConstructorEvent)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp() || this.getTimestamp() != castedRecord.getTimestamp() || this.getTraceId() != castedRecord.getTraceId() || this.getOrderIndex() != castedRecord.getOrderIndex()) {
            return false;
        }
        if (!this.getOperationSignature().equals(castedRecord.getOperationSignature())) {
            return false;
        }
        if (!this.getClassSignature().equals(castedRecord.getClassSignature())) {
            return false;
        }
        if (!this.getCalleeOperationSignature().equals(castedRecord.getCalleeOperationSignature())) {
            return false;
        }
        return this.getCalleeClassSignature().equals(castedRecord.getCalleeClassSignature());
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += (int)this.getTraceId();
        code += this.getOrderIndex();
        code += this.getOperationSignature().hashCode();
        code += this.getClassSignature().hashCode();
        code += this.getCalleeOperationSignature().hashCode();
        return code += this.getCalleeClassSignature().hashCode();
    }

    @Override
    public String toString() {
        Object result = "CallConstructorEvent: ";
        result = (String)result + "timestamp = ";
        result = (String)result + this.getTimestamp() + ", ";
        result = (String)result + "traceId = ";
        result = (String)result + this.getTraceId() + ", ";
        result = (String)result + "orderIndex = ";
        result = (String)result + this.getOrderIndex() + ", ";
        result = (String)result + "operationSignature = ";
        result = (String)result + this.getOperationSignature() + ", ";
        result = (String)result + "classSignature = ";
        result = (String)result + this.getClassSignature() + ", ";
        result = (String)result + "calleeOperationSignature = ";
        result = (String)result + this.getCalleeOperationSignature() + ", ";
        result = (String)result + "calleeClassSignature = ";
        result = (String)result + this.getCalleeClassSignature() + ", ";
        return result;
    }
}

