/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.trace.operation.constructor.object;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.flow.ICallObjectRecord;
import kieker.common.record.flow.trace.operation.constructor.CallConstructorEvent;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;

public class CallConstructorObjectEvent
extends CallConstructorEvent
implements ICallObjectRecord {
    public static final int SIZE = 44;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, String.class, String.class, String.class, String.class, Integer.TYPE, Integer.TYPE};
    public static final String[] VALUE_NAMES = new String[]{"timestamp", "traceId", "orderIndex", "operationSignature", "classSignature", "calleeOperationSignature", "calleeClassSignature", "objectId", "calleeObjectId"};
    public static final int OBJECT_ID = 0;
    public static final int CALLEE_OBJECT_ID = 0;
    private static final long serialVersionUID = 8314260268662611478L;
    private final int objectId;
    private final int calleeObjectId;

    public CallConstructorObjectEvent(long timestamp, long traceId, int orderIndex, String operationSignature, String classSignature, String calleeOperationSignature, String calleeClassSignature, int objectId, int calleeObjectId) {
        super(timestamp, traceId, orderIndex, operationSignature, classSignature, calleeOperationSignature, calleeClassSignature);
        this.objectId = objectId;
        this.calleeObjectId = calleeObjectId;
    }

    public CallConstructorObjectEvent(IValueDeserializer deserializer) throws RecordInstantiationException {
        super(deserializer);
        this.objectId = deserializer.getInt();
        this.calleeObjectId = deserializer.getInt();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
        serializer.putLong(this.getTraceId());
        serializer.putInt(this.getOrderIndex());
        serializer.putString(this.getOperationSignature());
        serializer.putString(this.getClassSignature());
        serializer.putString(this.getCalleeOperationSignature());
        serializer.putString(this.getCalleeClassSignature());
        serializer.putInt(this.getObjectId());
        serializer.putInt(this.getCalleeObjectId());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 44;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        CallConstructorObjectEvent castedRecord = (CallConstructorObjectEvent)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp() || this.getTimestamp() != castedRecord.getTimestamp() || this.getTraceId() != castedRecord.getTraceId() || this.getOrderIndex() != castedRecord.getOrderIndex()) {
            return false;
        }
        if (!this.getOperationSignature().equals(castedRecord.getOperationSignature())) {
            return false;
        }
        if (!this.getClassSignature().equals(castedRecord.getClassSignature())) {
            return false;
        }
        if (!this.getCalleeOperationSignature().equals(castedRecord.getCalleeOperationSignature())) {
            return false;
        }
        if (!this.getCalleeClassSignature().equals(castedRecord.getCalleeClassSignature())) {
            return false;
        }
        if (this.getObjectId() != castedRecord.getObjectId()) {
            return false;
        }
        return this.getCalleeObjectId() == castedRecord.getCalleeObjectId();
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += (int)this.getTraceId();
        code += this.getOrderIndex();
        code += this.getOperationSignature().hashCode();
        code += this.getClassSignature().hashCode();
        code += this.getCalleeOperationSignature().hashCode();
        code += this.getCalleeClassSignature().hashCode();
        code += this.getObjectId();
        return code += this.getCalleeObjectId();
    }

    @Override
    public final int getObjectId() {
        return this.objectId;
    }

    @Override
    public final int getCallerObjectId() {
        return this.getObjectId();
    }

    @Override
    public final int getCalleeObjectId() {
        return this.calleeObjectId;
    }

    @Override
    public String toString() {
        Object result = "CallConstructorObjectEvent: ";
        result = (String)result + "timestamp = ";
        result = (String)result + this.getTimestamp() + ", ";
        result = (String)result + "traceId = ";
        result = (String)result + this.getTraceId() + ", ";
        result = (String)result + "orderIndex = ";
        result = (String)result + this.getOrderIndex() + ", ";
        result = (String)result + "operationSignature = ";
        result = (String)result + this.getOperationSignature() + ", ";
        result = (String)result + "classSignature = ";
        result = (String)result + this.getClassSignature() + ", ";
        result = (String)result + "calleeOperationSignature = ";
        result = (String)result + this.getCalleeOperationSignature() + ", ";
        result = (String)result + "calleeClassSignature = ";
        result = (String)result + this.getCalleeClassSignature() + ", ";
        result = (String)result + "objectId = ";
        result = (String)result + this.getObjectId() + ", ";
        result = (String)result + "calleeObjectId = ";
        result = (String)result + this.getCalleeObjectId() + ", ";
        return result;
    }
}

