/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.trace.operation.object;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.flow.IObjectRecord;
import kieker.common.record.flow.trace.operation.BeforeOperationEvent;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;

public class BeforeOperationObjectEvent
extends BeforeOperationEvent
implements IObjectRecord {
    public static final int SIZE = 32;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, String.class, String.class, Integer.TYPE};
    public static final String[] VALUE_NAMES = new String[]{"timestamp", "traceId", "orderIndex", "operationSignature", "classSignature", "objectId"};
    public static final int OBJECT_ID = 0;
    private static final long serialVersionUID = -6304010818559607110L;
    private final int objectId;

    public BeforeOperationObjectEvent(long timestamp, long traceId, int orderIndex, String operationSignature, String classSignature, int objectId) {
        super(timestamp, traceId, orderIndex, operationSignature, classSignature);
        this.objectId = objectId;
    }

    public BeforeOperationObjectEvent(IValueDeserializer deserializer) throws RecordInstantiationException {
        super(deserializer);
        this.objectId = deserializer.getInt();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
        serializer.putLong(this.getTraceId());
        serializer.putInt(this.getOrderIndex());
        serializer.putString(this.getOperationSignature());
        serializer.putString(this.getClassSignature());
        serializer.putInt(this.getObjectId());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 32;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        BeforeOperationObjectEvent castedRecord = (BeforeOperationObjectEvent)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp() || this.getTimestamp() != castedRecord.getTimestamp() || this.getTraceId() != castedRecord.getTraceId() || this.getOrderIndex() != castedRecord.getOrderIndex()) {
            return false;
        }
        if (!this.getOperationSignature().equals(castedRecord.getOperationSignature())) {
            return false;
        }
        if (!this.getClassSignature().equals(castedRecord.getClassSignature())) {
            return false;
        }
        return this.getObjectId() == castedRecord.getObjectId();
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += (int)this.getTraceId();
        code += this.getOrderIndex();
        code += this.getOperationSignature().hashCode();
        code += this.getClassSignature().hashCode();
        return code += this.getObjectId();
    }

    @Override
    public final int getObjectId() {
        return this.objectId;
    }

    @Override
    public String toString() {
        Object result = "BeforeOperationObjectEvent: ";
        result = (String)result + "timestamp = ";
        result = (String)result + this.getTimestamp() + ", ";
        result = (String)result + "traceId = ";
        result = (String)result + this.getTraceId() + ", ";
        result = (String)result + "orderIndex = ";
        result = (String)result + this.getOrderIndex() + ", ";
        result = (String)result + "operationSignature = ";
        result = (String)result + this.getOperationSignature() + ", ";
        result = (String)result + "classSignature = ";
        result = (String)result + this.getClassSignature() + ", ";
        result = (String)result + "objectId = ";
        result = (String)result + this.getObjectId() + ", ";
        return result;
    }
}

