/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.io;

import java.nio.CharBuffer;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.io.AbstractValueDeserializer;
import kieker.common.record.io.IValueDeserializer;

public class TextValueDeserializer
extends AbstractValueDeserializer
implements IValueDeserializer {
    private final CharBuffer buffer;

    protected TextValueDeserializer(CharBuffer buffer) {
        this.buffer = buffer;
    }

    public static TextValueDeserializer create(CharBuffer buffer) {
        return new TextValueDeserializer(buffer);
    }

    @Override
    public boolean getBoolean() {
        return Boolean.parseBoolean(this.readValue());
    }

    @Override
    public byte getByte() throws NumberFormatException {
        return Byte.parseByte(this.readValue());
    }

    @Override
    public char getChar() {
        char ch = this.buffer.get();
        this.buffer.get();
        return ch;
    }

    @Override
    public short getShort() throws NumberFormatException {
        return Short.parseShort(this.readValue());
    }

    @Override
    public int getInt() throws NumberFormatException {
        return Integer.parseInt(this.readValue());
    }

    @Override
    public long getLong() throws NumberFormatException {
        return Long.parseLong(this.readValue());
    }

    @Override
    public float getFloat() throws NumberFormatException {
        return Float.parseFloat(this.readValue());
    }

    @Override
    public double getDouble() throws NumberFormatException {
        return Double.parseDouble(this.readValue());
    }

    @Override
    public String getString() {
        return this.readValue();
    }

    @Override
    public <T extends Enum<T>> T getEnumeration(Class<T> clazz) throws RecordInstantiationException {
        int value = Integer.parseInt(this.readValue());
        return this.enumerationValueOf(clazz, value);
    }

    private String readValue() {
        char[] charArray = new char[this.buffer.limit()];
        int remaining = this.buffer.limit() - this.buffer.position();
        int i = 0;
        if (remaining > 0) {
            char ch;
            do {
                if ((ch = this.buffer.get()) == '\\') {
                    charArray[i++] = ch;
                    charArray[i++] = this.buffer.get();
                    continue;
                }
                if (ch == ';') continue;
                charArray[i++] = ch;
            } while (ch != ';' && i < remaining);
            return new String(charArray, 0, i);
        }
        return "";
    }
}

