/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.jvm;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;
import kieker.common.record.jvm.AbstractJVMRecord;

public class GCRecord
extends AbstractJVMRecord {
    public static final int SIZE = 36;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, String.class, String.class, String.class, Long.TYPE, Long.TYPE};
    public static final String[] VALUE_NAMES = new String[]{"timestamp", "hostname", "vmName", "gcName", "collectionCount", "collectionTimeMS"};
    public static final String GC_NAME = "";
    private static final long serialVersionUID = -314644197119857213L;
    private final String gcName;
    private final long collectionCount;
    private final long collectionTimeMS;

    public GCRecord(long timestamp, String hostname, String vmName, String gcName, long collectionCount, long collectionTimeMS) {
        super(timestamp, hostname, vmName);
        this.gcName = gcName == null ? GC_NAME : gcName;
        this.collectionCount = collectionCount;
        this.collectionTimeMS = collectionTimeMS;
    }

    public GCRecord(IValueDeserializer deserializer) throws RecordInstantiationException {
        super(deserializer);
        this.gcName = deserializer.getString();
        this.collectionCount = deserializer.getLong();
        this.collectionTimeMS = deserializer.getLong();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
        serializer.putString(this.getHostname());
        serializer.putString(this.getVmName());
        serializer.putString(this.getGcName());
        serializer.putLong(this.getCollectionCount());
        serializer.putLong(this.getCollectionTimeMS());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 36;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        GCRecord castedRecord = (GCRecord)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp() || this.getTimestamp() != castedRecord.getTimestamp() || !this.getHostname().equals(castedRecord.getHostname()) || !this.getVmName().equals(castedRecord.getVmName())) {
            return false;
        }
        if (!this.getGcName().equals(castedRecord.getGcName())) {
            return false;
        }
        if (this.getCollectionCount() != castedRecord.getCollectionCount()) {
            return false;
        }
        return this.getCollectionTimeMS() == castedRecord.getCollectionTimeMS();
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += this.getHostname().hashCode();
        code += this.getVmName().hashCode();
        code += this.getGcName().hashCode();
        code += (int)this.getCollectionCount();
        return code += (int)this.getCollectionTimeMS();
    }

    public final String getGcName() {
        return this.gcName;
    }

    public final long getCollectionCount() {
        return this.collectionCount;
    }

    public final long getCollectionTimeMS() {
        return this.collectionTimeMS;
    }

    @Override
    public String toString() {
        Object result = "GCRecord: ";
        result = (String)result + "timestamp = ";
        result = (String)result + this.getTimestamp() + ", ";
        result = (String)result + "hostname = ";
        result = (String)result + this.getHostname() + ", ";
        result = (String)result + "vmName = ";
        result = (String)result + this.getVmName() + ", ";
        result = (String)result + "gcName = ";
        result = (String)result + this.getGcName() + ", ";
        result = (String)result + "collectionCount = ";
        result = (String)result + this.getCollectionCount() + ", ";
        result = (String)result + "collectionTimeMS = ";
        result = (String)result + this.getCollectionTimeMS() + ", ";
        return result;
    }
}

