/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.jvm;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;
import kieker.common.record.jvm.AbstractJVMRecord;

public class MemoryRecord
extends AbstractJVMRecord {
    public static final int SIZE = 84;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, String.class, String.class, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE};
    public static final String[] VALUE_NAMES = new String[]{"timestamp", "hostname", "vmName", "heapMaxBytes", "heapUsedBytes", "heapCommittedBytes", "heapInitBytes", "nonHeapMaxBytes", "nonHeapUsedBytes", "nonHeapCommittedBytes", "nonHeapInitBytes", "objectPendingFinalizationCount"};
    private static final long serialVersionUID = -9025858519361306011L;
    private final long heapMaxBytes;
    private final long heapUsedBytes;
    private final long heapCommittedBytes;
    private final long heapInitBytes;
    private final long nonHeapMaxBytes;
    private final long nonHeapUsedBytes;
    private final long nonHeapCommittedBytes;
    private final long nonHeapInitBytes;
    private final int objectPendingFinalizationCount;

    public MemoryRecord(long timestamp, String hostname, String vmName, long heapMaxBytes, long heapUsedBytes, long heapCommittedBytes, long heapInitBytes, long nonHeapMaxBytes, long nonHeapUsedBytes, long nonHeapCommittedBytes, long nonHeapInitBytes, int objectPendingFinalizationCount) {
        super(timestamp, hostname, vmName);
        this.heapMaxBytes = heapMaxBytes;
        this.heapUsedBytes = heapUsedBytes;
        this.heapCommittedBytes = heapCommittedBytes;
        this.heapInitBytes = heapInitBytes;
        this.nonHeapMaxBytes = nonHeapMaxBytes;
        this.nonHeapUsedBytes = nonHeapUsedBytes;
        this.nonHeapCommittedBytes = nonHeapCommittedBytes;
        this.nonHeapInitBytes = nonHeapInitBytes;
        this.objectPendingFinalizationCount = objectPendingFinalizationCount;
    }

    public MemoryRecord(IValueDeserializer deserializer) throws RecordInstantiationException {
        super(deserializer);
        this.heapMaxBytes = deserializer.getLong();
        this.heapUsedBytes = deserializer.getLong();
        this.heapCommittedBytes = deserializer.getLong();
        this.heapInitBytes = deserializer.getLong();
        this.nonHeapMaxBytes = deserializer.getLong();
        this.nonHeapUsedBytes = deserializer.getLong();
        this.nonHeapCommittedBytes = deserializer.getLong();
        this.nonHeapInitBytes = deserializer.getLong();
        this.objectPendingFinalizationCount = deserializer.getInt();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
        serializer.putString(this.getHostname());
        serializer.putString(this.getVmName());
        serializer.putLong(this.getHeapMaxBytes());
        serializer.putLong(this.getHeapUsedBytes());
        serializer.putLong(this.getHeapCommittedBytes());
        serializer.putLong(this.getHeapInitBytes());
        serializer.putLong(this.getNonHeapMaxBytes());
        serializer.putLong(this.getNonHeapUsedBytes());
        serializer.putLong(this.getNonHeapCommittedBytes());
        serializer.putLong(this.getNonHeapInitBytes());
        serializer.putInt(this.getObjectPendingFinalizationCount());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 84;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        MemoryRecord castedRecord = (MemoryRecord)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp() || this.getTimestamp() != castedRecord.getTimestamp() || !this.getHostname().equals(castedRecord.getHostname()) || !this.getVmName().equals(castedRecord.getVmName())) {
            return false;
        }
        if (this.getHeapMaxBytes() != castedRecord.getHeapMaxBytes()) {
            return false;
        }
        if (this.getHeapUsedBytes() != castedRecord.getHeapUsedBytes()) {
            return false;
        }
        if (this.getHeapCommittedBytes() != castedRecord.getHeapCommittedBytes()) {
            return false;
        }
        if (this.getHeapInitBytes() != castedRecord.getHeapInitBytes()) {
            return false;
        }
        if (this.getNonHeapMaxBytes() != castedRecord.getNonHeapMaxBytes()) {
            return false;
        }
        if (this.getNonHeapUsedBytes() != castedRecord.getNonHeapUsedBytes()) {
            return false;
        }
        if (this.getNonHeapCommittedBytes() != castedRecord.getNonHeapCommittedBytes()) {
            return false;
        }
        if (this.getNonHeapInitBytes() != castedRecord.getNonHeapInitBytes()) {
            return false;
        }
        return this.getObjectPendingFinalizationCount() == castedRecord.getObjectPendingFinalizationCount();
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += this.getHostname().hashCode();
        code += this.getVmName().hashCode();
        code += (int)this.getHeapMaxBytes();
        code += (int)this.getHeapUsedBytes();
        code += (int)this.getHeapCommittedBytes();
        code += (int)this.getHeapInitBytes();
        code += (int)this.getNonHeapMaxBytes();
        code += (int)this.getNonHeapUsedBytes();
        code += (int)this.getNonHeapCommittedBytes();
        code += (int)this.getNonHeapInitBytes();
        return code += this.getObjectPendingFinalizationCount();
    }

    public final long getHeapMaxBytes() {
        return this.heapMaxBytes;
    }

    public final long getHeapUsedBytes() {
        return this.heapUsedBytes;
    }

    public final long getHeapCommittedBytes() {
        return this.heapCommittedBytes;
    }

    public final long getHeapInitBytes() {
        return this.heapInitBytes;
    }

    public final long getNonHeapMaxBytes() {
        return this.nonHeapMaxBytes;
    }

    public final long getNonHeapUsedBytes() {
        return this.nonHeapUsedBytes;
    }

    public final long getNonHeapCommittedBytes() {
        return this.nonHeapCommittedBytes;
    }

    public final long getNonHeapInitBytes() {
        return this.nonHeapInitBytes;
    }

    public final int getObjectPendingFinalizationCount() {
        return this.objectPendingFinalizationCount;
    }

    @Override
    public String toString() {
        Object result = "MemoryRecord: ";
        result = (String)result + "timestamp = ";
        result = (String)result + this.getTimestamp() + ", ";
        result = (String)result + "hostname = ";
        result = (String)result + this.getHostname() + ", ";
        result = (String)result + "vmName = ";
        result = (String)result + this.getVmName() + ", ";
        result = (String)result + "heapMaxBytes = ";
        result = (String)result + this.getHeapMaxBytes() + ", ";
        result = (String)result + "heapUsedBytes = ";
        result = (String)result + this.getHeapUsedBytes() + ", ";
        result = (String)result + "heapCommittedBytes = ";
        result = (String)result + this.getHeapCommittedBytes() + ", ";
        result = (String)result + "heapInitBytes = ";
        result = (String)result + this.getHeapInitBytes() + ", ";
        result = (String)result + "nonHeapMaxBytes = ";
        result = (String)result + this.getNonHeapMaxBytes() + ", ";
        result = (String)result + "nonHeapUsedBytes = ";
        result = (String)result + this.getNonHeapUsedBytes() + ", ";
        result = (String)result + "nonHeapCommittedBytes = ";
        result = (String)result + this.getNonHeapCommittedBytes() + ", ";
        result = (String)result + "nonHeapInitBytes = ";
        result = (String)result + this.getNonHeapInitBytes() + ", ";
        result = (String)result + "objectPendingFinalizationCount = ";
        result = (String)result + this.getObjectPendingFinalizationCount() + ", ";
        return result;
    }
}

