/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.misc;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;
import kieker.common.util.Version;

public class KiekerMetadataRecord
extends AbstractMonitoringRecord {
    public static final int SIZE = 37;
    public static final Class<?>[] TYPES = new Class[]{String.class, String.class, String.class, Integer.TYPE, Boolean.TYPE, Long.TYPE, String.class, Long.TYPE};
    public static final String NO_CONTROLLERNAME = "<no-controller-name>";
    public static final String NO_HOSTNAME = "<no-hostname>";
    public static final String NO_TIMESOURCE = "<no-timesource>";
    public static final String NO_TIMEUNIT = "NANOSECONDS";
    public static final String[] VALUE_NAMES = new String[]{"version", "controllerName", "hostname", "experimentId", "debugMode", "timeOffset", "timeUnit", "numberOfRecords"};
    public static final String VERSION = Version.getVERSION();
    public static final String CONTROLLER_NAME = "<no-controller-name>";
    public static final String HOSTNAME = "<no-hostname>";
    public static final int EXPERIMENT_ID = 0;
    public static final boolean DEBUG_MODE = false;
    public static final long TIME_OFFSET = 0L;
    public static final String TIME_UNIT = "NANOSECONDS";
    public static final long NUMBER_OF_RECORDS = 0L;
    private static final long serialVersionUID = 8241152536143822747L;
    private final String version;
    private final String controllerName;
    private final String hostname;
    private final int experimentId;
    private final boolean debugMode;
    private final long timeOffset;
    private final String timeUnit;
    private final long numberOfRecords;

    public KiekerMetadataRecord(String version, String controllerName, String hostname, int experimentId, boolean debugMode, long timeOffset, String timeUnit, long numberOfRecords) {
        this.version = version == null ? VERSION : version;
        this.controllerName = controllerName == null ? "<no-controller-name>" : controllerName;
        this.hostname = hostname == null ? "<no-hostname>" : hostname;
        this.experimentId = experimentId;
        this.debugMode = debugMode;
        this.timeOffset = timeOffset;
        this.timeUnit = timeUnit == null ? "NANOSECONDS" : timeUnit;
        this.numberOfRecords = numberOfRecords;
    }

    public KiekerMetadataRecord(IValueDeserializer deserializer) throws RecordInstantiationException {
        this.version = deserializer.getString();
        this.controllerName = deserializer.getString();
        this.hostname = deserializer.getString();
        this.experimentId = deserializer.getInt();
        this.debugMode = deserializer.getBoolean();
        this.timeOffset = deserializer.getLong();
        this.timeUnit = deserializer.getString();
        this.numberOfRecords = deserializer.getLong();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putString(this.getVersion());
        serializer.putString(this.getControllerName());
        serializer.putString(this.getHostname());
        serializer.putInt(this.getExperimentId());
        serializer.putBoolean(this.isDebugMode());
        serializer.putLong(this.getTimeOffset());
        serializer.putString(this.getTimeUnit());
        serializer.putLong(this.getNumberOfRecords());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 37;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        KiekerMetadataRecord castedRecord = (KiekerMetadataRecord)obj;
        if (!(this.getLoggingTimestamp() == castedRecord.getLoggingTimestamp() && this.getVersion().equals(castedRecord.getVersion()) && this.getControllerName().equals(castedRecord.getControllerName()) && this.getHostname().equals(castedRecord.getHostname()))) {
            return false;
        }
        if (this.getExperimentId() != castedRecord.getExperimentId()) {
            return false;
        }
        if (this.isDebugMode() != castedRecord.isDebugMode()) {
            return false;
        }
        if (this.getTimeOffset() != castedRecord.getTimeOffset()) {
            return false;
        }
        if (!this.getTimeUnit().equals(castedRecord.getTimeUnit())) {
            return false;
        }
        return this.getNumberOfRecords() == castedRecord.getNumberOfRecords();
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += this.getVersion().hashCode();
        code += this.getControllerName().hashCode();
        code += this.getHostname().hashCode();
        code += this.getExperimentId();
        code += this.isDebugMode() ? 0 : 1;
        code += (int)this.getTimeOffset();
        code += this.getTimeUnit().hashCode();
        return code += (int)this.getNumberOfRecords();
    }

    public final String getVersion() {
        return this.version;
    }

    public final String getControllerName() {
        return this.controllerName;
    }

    public final String getHostname() {
        return this.hostname;
    }

    public final int getExperimentId() {
        return this.experimentId;
    }

    public final boolean isDebugMode() {
        return this.debugMode;
    }

    public final long getTimeOffset() {
        return this.timeOffset;
    }

    public final String getTimeUnit() {
        return this.timeUnit;
    }

    public final long getNumberOfRecords() {
        return this.numberOfRecords;
    }

    @Override
    public String toString() {
        Object result = "KiekerMetadataRecord: ";
        result = (String)result + "version = ";
        result = (String)result + this.getVersion() + ", ";
        result = (String)result + "controllerName = ";
        result = (String)result + this.getControllerName() + ", ";
        result = (String)result + "hostname = ";
        result = (String)result + this.getHostname() + ", ";
        result = (String)result + "experimentId = ";
        result = (String)result + this.getExperimentId() + ", ";
        result = (String)result + "debugMode = ";
        result = (String)result + this.isDebugMode() + ", ";
        result = (String)result + "timeOffset = ";
        result = (String)result + this.getTimeOffset() + ", ";
        result = (String)result + "timeUnit = ";
        result = (String)result + this.getTimeUnit() + ", ";
        result = (String)result + "numberOfRecords = ";
        result = (String)result + this.getNumberOfRecords() + ", ";
        return result;
    }
}

