/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.misc;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;

public class OperationCallEvent
extends AbstractMonitoringRecord {
    public static final int SIZE = 16;
    public static final Class<?>[] TYPES = new Class[]{String.class, String.class, String.class, String.class};
    public static final String[] VALUE_NAMES = new String[]{"sourceComponent", "sourceOperation", "targetComponent", "targetOperation"};
    public static final String SOURCE_COMPONENT = "";
    public static final String SOURCE_OPERATION = "";
    public static final String TARGET_COMPONENT = "";
    public static final String TARGET_OPERATION = "";
    private static final long serialVersionUID = -5250152168812250464L;
    private final String sourceComponent;
    private final String sourceOperation;
    private final String targetComponent;
    private final String targetOperation;

    public OperationCallEvent(String sourceComponent, String sourceOperation, String targetComponent, String targetOperation) {
        this.sourceComponent = sourceComponent == null ? "" : sourceComponent;
        this.sourceOperation = sourceOperation == null ? "" : sourceOperation;
        this.targetComponent = targetComponent == null ? "" : targetComponent;
        this.targetOperation = targetOperation == null ? "" : targetOperation;
    }

    public OperationCallEvent(IValueDeserializer deserializer) throws RecordInstantiationException {
        this.sourceComponent = deserializer.getString();
        this.sourceOperation = deserializer.getString();
        this.targetComponent = deserializer.getString();
        this.targetOperation = deserializer.getString();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putString(this.getSourceComponent());
        serializer.putString(this.getSourceOperation());
        serializer.putString(this.getTargetComponent());
        serializer.putString(this.getTargetOperation());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 16;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        OperationCallEvent castedRecord = (OperationCallEvent)obj;
        if (!(this.getLoggingTimestamp() == castedRecord.getLoggingTimestamp() && this.getSourceComponent().equals(castedRecord.getSourceComponent()) && this.getSourceOperation().equals(castedRecord.getSourceOperation()) && this.getTargetComponent().equals(castedRecord.getTargetComponent()))) {
            return false;
        }
        return this.getTargetOperation().equals(castedRecord.getTargetOperation());
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += this.getSourceComponent().hashCode();
        code += this.getSourceOperation().hashCode();
        code += this.getTargetComponent().hashCode();
        return code += this.getTargetOperation().hashCode();
    }

    public final String getSourceComponent() {
        return this.sourceComponent;
    }

    public final String getSourceOperation() {
        return this.sourceOperation;
    }

    public final String getTargetComponent() {
        return this.targetComponent;
    }

    public final String getTargetOperation() {
        return this.targetOperation;
    }

    @Override
    public String toString() {
        Object result = "OperationCallEvent: ";
        result = (String)result + "sourceComponent = ";
        result = (String)result + this.getSourceComponent() + ", ";
        result = (String)result + "sourceOperation = ";
        result = (String)result + this.getSourceOperation() + ", ";
        result = (String)result + "targetComponent = ";
        result = (String)result + this.getTargetComponent() + ", ";
        result = (String)result + "targetOperation = ";
        result = (String)result + this.getTargetOperation() + ", ";
        return result;
    }
}

