/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.misc;

import java.io.UnsupportedEncodingException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;
import kieker.common.registry.reader.ReaderRegistry;

public final class RegistryRecord
extends AbstractMonitoringRecord {
    public static final int SIZE = 8;
    public static final Class<?>[] TYPES = new Class[]{Integer.TYPE, String.class};
    public static final String ENCODING = "UTF-8";
    public static final int CLASS_ID = -1;
    private static final long serialVersionUID = -8264706549927546468L;
    private final int id;
    private final String string;
    private final byte[] strBytes;

    public RegistryRecord(int id, String string) {
        this.id = id;
        this.string = string;
        this.strBytes = RegistryRecord.stringToBytes(this.string);
    }

    public RegistryRecord(Object[] values) {
        AbstractMonitoringRecord.checkArray(values, TYPES);
        this.id = (Integer)values[0];
        this.string = (String)values[1];
        this.strBytes = RegistryRecord.stringToBytes(this.string);
    }

    public RegistryRecord(IValueDeserializer deserializer) throws BufferUnderflowException {
        this.id = deserializer.getInt();
        this.string = deserializer.getString();
        this.strBytes = this.string.getBytes();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putInt(this.getId());
        serializer.putString(this.getString());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return new String[]{"id", "string", "strBytes"};
    }

    @Override
    public int getSize() {
        return 8 + this.strBytes.length;
    }

    public final byte[] getStrBytes() {
        return this.strBytes;
    }

    public final int getId() {
        return this.id;
    }

    public final String getString() {
        return this.string;
    }

    public static final void registerRecordInRegistry(ByteBuffer buffer, ReaderRegistry<String> stringRegistry) throws BufferOverflowException {
        int id = buffer.getInt();
        byte[] strBytes = new byte[buffer.getInt()];
        buffer.get(strBytes);
        String string = RegistryRecord.bytesToString(strBytes);
        stringRegistry.register(id, string);
    }

    private static String bytesToString(byte[] strBytes) {
        String str;
        try {
            str = new String(strBytes, ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            str = new String(strBytes, Charset.defaultCharset());
        }
        return str;
    }

    private static byte[] stringToBytes(String string) {
        byte[] tmpBytes;
        try {
            tmpBytes = string.getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            tmpBytes = string.getBytes(Charset.defaultCharset());
        }
        return tmpBytes;
    }
}

