/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.remotecontrol;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;
import kieker.common.record.remotecontrol.IParameterValueEvent;

public class AddParameterValueEvent
extends AbstractMonitoringRecord
implements IParameterValueEvent {
    public static final int SIZE = 12;
    public static final Class<?>[] TYPES = new Class[]{String.class, String.class, String.class};
    public static final String[] VALUE_NAMES = new String[]{"pattern", "name", "value"};
    public static final String PATTERN = "";
    public static final String NAME = "";
    public static final String VALUE = "";
    private static final long serialVersionUID = -5279430930031250890L;
    private final String pattern;
    private final String name;
    private final String value;

    public AddParameterValueEvent(String pattern, String name, String value) {
        this.pattern = pattern == null ? "" : pattern;
        this.name = name == null ? "" : name;
        this.value = value == null ? "" : value;
    }

    public AddParameterValueEvent(IValueDeserializer deserializer) throws RecordInstantiationException {
        this.pattern = deserializer.getString();
        this.name = deserializer.getString();
        this.value = deserializer.getString();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putString(this.getPattern());
        serializer.putString(this.getName());
        serializer.putString(this.getValue());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 12;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AddParameterValueEvent castedRecord = (AddParameterValueEvent)obj;
        return this.getLoggingTimestamp() == castedRecord.getLoggingTimestamp() && this.getPattern().equals(castedRecord.getPattern()) && this.getName().equals(castedRecord.getName()) && this.getValue().equals(castedRecord.getValue());
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += this.getPattern().hashCode();
        code += this.getName().hashCode();
        return code += this.getValue().hashCode();
    }

    @Override
    public final String getPattern() {
        return this.pattern;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        Object result = "AddParameterValueEvent: ";
        result = (String)result + "pattern = ";
        result = (String)result + this.getPattern() + ", ";
        result = (String)result + "name = ";
        result = (String)result + this.getName() + ", ";
        result = (String)result + "value = ";
        result = (String)result + this.getValue() + ", ";
        return result;
    }
}

