/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.remotecontrol;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;
import kieker.common.record.remotecontrol.IRemoteControlEvent;

public class DeactivationEvent
extends AbstractMonitoringRecord
implements IRemoteControlEvent {
    public static final int SIZE = 4;
    public static final Class<?>[] TYPES = new Class[]{String.class};
    public static final String[] VALUE_NAMES = new String[]{"pattern"};
    public static final String PATTERN = "";
    private static final long serialVersionUID = 8080379087547198579L;
    private final String pattern;

    public DeactivationEvent(String pattern) {
        this.pattern = pattern == null ? PATTERN : pattern;
    }

    public DeactivationEvent(IValueDeserializer deserializer) throws RecordInstantiationException {
        this.pattern = deserializer.getString();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putString(this.getPattern());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 4;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DeactivationEvent castedRecord = (DeactivationEvent)obj;
        return this.getLoggingTimestamp() == castedRecord.getLoggingTimestamp() && this.getPattern().equals(castedRecord.getPattern());
    }

    @Override
    public int hashCode() {
        int code = 0;
        return code += this.getPattern().hashCode();
    }

    @Override
    public final String getPattern() {
        return this.pattern;
    }

    @Override
    public String toString() {
        Object result = "DeactivationEvent: ";
        result = (String)result + "pattern = ";
        result = (String)result + this.getPattern() + ", ";
        return result;
    }
}

