/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.system;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;

public class DiskUsageRecord
extends AbstractMonitoringRecord {
    public static final int SIZE = 64;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, String.class, String.class, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE};
    public static final String[] VALUE_NAMES = new String[]{"timestamp", "hostname", "deviceName", "queue", "readBytesPerSecond", "readsPerSecond", "serviceTime", "writeBytesPerSecond", "writesPerSecond"};
    public static final long TIMESTAMP = 0L;
    public static final String HOSTNAME = "";
    public static final String DEVICE_NAME = "";
    public static final double QUEUE = 0.0;
    public static final double READ_BYTES_PER_SECOND = 0.0;
    public static final double READS_PER_SECOND = 0.0;
    public static final double SERVICE_TIME = 0.0;
    public static final double WRITE_BYTES_PER_SECOND = 0.0;
    public static final double WRITES_PER_SECOND = 0.0;
    private static final long serialVersionUID = 2474236414042988334L;
    private final long timestamp;
    private final String hostname;
    private final String deviceName;
    private final double queue;
    private final double readBytesPerSecond;
    private final double readsPerSecond;
    private final double serviceTime;
    private final double writeBytesPerSecond;
    private final double writesPerSecond;

    public DiskUsageRecord(long timestamp, String hostname, String deviceName, double queue, double readBytesPerSecond, double readsPerSecond, double serviceTime, double writeBytesPerSecond, double writesPerSecond) {
        this.timestamp = timestamp;
        this.hostname = hostname == null ? "" : hostname;
        this.deviceName = deviceName == null ? "" : deviceName;
        this.queue = queue;
        this.readBytesPerSecond = readBytesPerSecond;
        this.readsPerSecond = readsPerSecond;
        this.serviceTime = serviceTime;
        this.writeBytesPerSecond = writeBytesPerSecond;
        this.writesPerSecond = writesPerSecond;
    }

    public DiskUsageRecord(IValueDeserializer deserializer) throws RecordInstantiationException {
        this.timestamp = deserializer.getLong();
        this.hostname = deserializer.getString();
        this.deviceName = deserializer.getString();
        this.queue = deserializer.getDouble();
        this.readBytesPerSecond = deserializer.getDouble();
        this.readsPerSecond = deserializer.getDouble();
        this.serviceTime = deserializer.getDouble();
        this.writeBytesPerSecond = deserializer.getDouble();
        this.writesPerSecond = deserializer.getDouble();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
        serializer.putString(this.getHostname());
        serializer.putString(this.getDeviceName());
        serializer.putDouble(this.getQueue());
        serializer.putDouble(this.getReadBytesPerSecond());
        serializer.putDouble(this.getReadsPerSecond());
        serializer.putDouble(this.getServiceTime());
        serializer.putDouble(this.getWriteBytesPerSecond());
        serializer.putDouble(this.getWritesPerSecond());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 64;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DiskUsageRecord castedRecord = (DiskUsageRecord)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp() || this.getTimestamp() != castedRecord.getTimestamp() || !this.getHostname().equals(castedRecord.getHostname()) || !this.getDeviceName().equals(castedRecord.getDeviceName())) {
            return false;
        }
        if (AbstractMonitoringRecord.isNotEqual(this.getQueue(), castedRecord.getQueue())) {
            return false;
        }
        if (AbstractMonitoringRecord.isNotEqual(this.getReadBytesPerSecond(), castedRecord.getReadBytesPerSecond())) {
            return false;
        }
        if (AbstractMonitoringRecord.isNotEqual(this.getReadsPerSecond(), castedRecord.getReadsPerSecond())) {
            return false;
        }
        if (AbstractMonitoringRecord.isNotEqual(this.getServiceTime(), castedRecord.getServiceTime())) {
            return false;
        }
        if (AbstractMonitoringRecord.isNotEqual(this.getWriteBytesPerSecond(), castedRecord.getWriteBytesPerSecond())) {
            return false;
        }
        return !AbstractMonitoringRecord.isNotEqual(this.getWritesPerSecond(), castedRecord.getWritesPerSecond());
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += this.getHostname().hashCode();
        code += this.getDeviceName().hashCode();
        code += (int)this.getQueue();
        code += (int)this.getReadBytesPerSecond();
        code += (int)this.getReadsPerSecond();
        code += (int)this.getServiceTime();
        code += (int)this.getWriteBytesPerSecond();
        return code += (int)this.getWritesPerSecond();
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final String getHostname() {
        return this.hostname;
    }

    public final String getDeviceName() {
        return this.deviceName;
    }

    public final double getQueue() {
        return this.queue;
    }

    public final double getReadBytesPerSecond() {
        return this.readBytesPerSecond;
    }

    public final double getReadsPerSecond() {
        return this.readsPerSecond;
    }

    public final double getServiceTime() {
        return this.serviceTime;
    }

    public final double getWriteBytesPerSecond() {
        return this.writeBytesPerSecond;
    }

    public final double getWritesPerSecond() {
        return this.writesPerSecond;
    }

    @Override
    public String toString() {
        Object result = "DiskUsageRecord: ";
        result = (String)result + "timestamp = ";
        result = (String)result + this.getTimestamp() + ", ";
        result = (String)result + "hostname = ";
        result = (String)result + this.getHostname() + ", ";
        result = (String)result + "deviceName = ";
        result = (String)result + this.getDeviceName() + ", ";
        result = (String)result + "queue = ";
        result = (String)result + this.getQueue() + ", ";
        result = (String)result + "readBytesPerSecond = ";
        result = (String)result + this.getReadBytesPerSecond() + ", ";
        result = (String)result + "readsPerSecond = ";
        result = (String)result + this.getReadsPerSecond() + ", ";
        result = (String)result + "serviceTime = ";
        result = (String)result + this.getServiceTime() + ", ";
        result = (String)result + "writeBytesPerSecond = ";
        result = (String)result + this.getWriteBytesPerSecond() + ", ";
        result = (String)result + "writesPerSecond = ";
        result = (String)result + this.getWritesPerSecond() + ", ";
        return result;
    }
}

