/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.system;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;

public class LoadAverageRecord
extends AbstractMonitoringRecord {
    public static final int SIZE = 36;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, String.class, Double.TYPE, Double.TYPE, Double.TYPE};
    public static final String[] VALUE_NAMES = new String[]{"timestamp", "hostname", "oneMinLoadAverage", "fiveMinLoadAverage", "fifteenMinLoadAverage"};
    public static final long TIMESTAMP = 0L;
    public static final String HOSTNAME = "";
    public static final double ONE_MIN_LOAD_AVERAGE = 0.0;
    public static final double FIVE_MIN_LOAD_AVERAGE = 0.0;
    public static final double FIFTEEN_MIN_LOAD_AVERAGE = 0.0;
    private static final long serialVersionUID = -664763923774505966L;
    private final long timestamp;
    private final String hostname;
    private final double oneMinLoadAverage;
    private final double fiveMinLoadAverage;
    private final double fifteenMinLoadAverage;

    public LoadAverageRecord(long timestamp, String hostname, double oneMinLoadAverage, double fiveMinLoadAverage, double fifteenMinLoadAverage) {
        this.timestamp = timestamp;
        this.hostname = hostname == null ? HOSTNAME : hostname;
        this.oneMinLoadAverage = oneMinLoadAverage;
        this.fiveMinLoadAverage = fiveMinLoadAverage;
        this.fifteenMinLoadAverage = fifteenMinLoadAverage;
    }

    public LoadAverageRecord(IValueDeserializer deserializer) throws RecordInstantiationException {
        this.timestamp = deserializer.getLong();
        this.hostname = deserializer.getString();
        this.oneMinLoadAverage = deserializer.getDouble();
        this.fiveMinLoadAverage = deserializer.getDouble();
        this.fifteenMinLoadAverage = deserializer.getDouble();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
        serializer.putString(this.getHostname());
        serializer.putDouble(this.getOneMinLoadAverage());
        serializer.putDouble(this.getFiveMinLoadAverage());
        serializer.putDouble(this.getFifteenMinLoadAverage());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 36;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        LoadAverageRecord castedRecord = (LoadAverageRecord)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp() || this.getTimestamp() != castedRecord.getTimestamp() || !this.getHostname().equals(castedRecord.getHostname()) || AbstractMonitoringRecord.isNotEqual(this.getOneMinLoadAverage(), castedRecord.getOneMinLoadAverage())) {
            return false;
        }
        if (AbstractMonitoringRecord.isNotEqual(this.getFiveMinLoadAverage(), castedRecord.getFiveMinLoadAverage())) {
            return false;
        }
        return !AbstractMonitoringRecord.isNotEqual(this.getFifteenMinLoadAverage(), castedRecord.getFifteenMinLoadAverage());
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += this.getHostname().hashCode();
        code += (int)this.getOneMinLoadAverage();
        code += (int)this.getFiveMinLoadAverage();
        return code += (int)this.getFifteenMinLoadAverage();
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final String getHostname() {
        return this.hostname;
    }

    public final double getOneMinLoadAverage() {
        return this.oneMinLoadAverage;
    }

    public final double getFiveMinLoadAverage() {
        return this.fiveMinLoadAverage;
    }

    public final double getFifteenMinLoadAverage() {
        return this.fifteenMinLoadAverage;
    }

    @Override
    public String toString() {
        Object result = "LoadAverageRecord: ";
        result = (String)result + "timestamp = ";
        result = (String)result + this.getTimestamp() + ", ";
        result = (String)result + "hostname = ";
        result = (String)result + this.getHostname() + ", ";
        result = (String)result + "oneMinLoadAverage = ";
        result = (String)result + this.getOneMinLoadAverage() + ", ";
        result = (String)result + "fiveMinLoadAverage = ";
        result = (String)result + this.getFiveMinLoadAverage() + ", ";
        result = (String)result + "fifteenMinLoadAverage = ";
        result = (String)result + this.getFifteenMinLoadAverage() + ", ";
        return result;
    }
}

