/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.system;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;

public class ResourceUtilizationRecord
extends AbstractMonitoringRecord {
    public static final int SIZE = 24;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, String.class, String.class, Double.TYPE};
    public static final String[] VALUE_NAMES = new String[]{"timestamp", "hostname", "resourceName", "utilization"};
    public static final long TIMESTAMP = 0L;
    public static final String HOSTNAME = "";
    public static final String RESOURCE_NAME = "";
    public static final double UTILIZATION = 0.0;
    private static final long serialVersionUID = 193790554451565711L;
    private final long timestamp;
    private final String hostname;
    private final String resourceName;
    private final double utilization;

    public ResourceUtilizationRecord(long timestamp, String hostname, String resourceName, double utilization) {
        this.timestamp = timestamp;
        this.hostname = hostname == null ? "" : hostname;
        this.resourceName = resourceName == null ? "" : resourceName;
        this.utilization = utilization;
    }

    public ResourceUtilizationRecord(IValueDeserializer deserializer) throws RecordInstantiationException {
        this.timestamp = deserializer.getLong();
        this.hostname = deserializer.getString();
        this.resourceName = deserializer.getString();
        this.utilization = deserializer.getDouble();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
        serializer.putString(this.getHostname());
        serializer.putString(this.getResourceName());
        serializer.putDouble(this.getUtilization());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 24;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ResourceUtilizationRecord castedRecord = (ResourceUtilizationRecord)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp() || this.getTimestamp() != castedRecord.getTimestamp() || !this.getHostname().equals(castedRecord.getHostname()) || !this.getResourceName().equals(castedRecord.getResourceName())) {
            return false;
        }
        return !AbstractMonitoringRecord.isNotEqual(this.getUtilization(), castedRecord.getUtilization());
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += this.getHostname().hashCode();
        code += this.getResourceName().hashCode();
        return code += (int)this.getUtilization();
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final String getHostname() {
        return this.hostname;
    }

    public final String getResourceName() {
        return this.resourceName;
    }

    public final double getUtilization() {
        return this.utilization;
    }

    @Override
    public String toString() {
        Object result = "ResourceUtilizationRecord: ";
        result = (String)result + "timestamp = ";
        result = (String)result + this.getTimestamp() + ", ";
        result = (String)result + "hostname = ";
        result = (String)result + this.getHostname() + ", ";
        result = (String)result + "resourceName = ";
        result = (String)result + this.getResourceName() + ", ";
        result = (String)result + "utilization = ";
        result = (String)result + this.getUtilization() + ", ";
        return result;
    }
}

