/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.registry.writer;

import java.util.HashMap;
import java.util.Map;
import kieker.common.registry.IRegistryListener;
import kieker.common.registry.writer.IWriterRegistry;
import kieker.common.registry.writer.WriterRegistryUtil;

public class WriterRegistry
implements IWriterRegistry<String> {
    private final Map<String, Integer> storage = new HashMap<String, Integer>();
    private int nextId;
    private final IRegistryListener<String> registryListener;
    private final long id;

    public WriterRegistry(IRegistryListener<String> registryListener) {
        this.registryListener = registryListener;
        this.id = WriterRegistryUtil.generateId();
    }

    @Override
    public int getId(String value) {
        Integer valueId = this.storage.get(value);
        if (valueId == null) {
            this.register(value);
            return this.storage.get(value);
        }
        return valueId;
    }

    @Override
    public void register(String value) {
        if (!this.storage.containsKey(value)) {
            int valueId = this.nextId++;
            this.storage.put(value, valueId);
            this.registryListener.onNewRegistryEntry(value, valueId);
        }
    }

    @Override
    public long getId() {
        return this.id;
    }
}

