/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.util.dataformat;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public final class LoggingTimestampConversionUtils {
    private static final String DATE_FORMAT_PATTERN = "yyyyMMdd'-'HHmmss";
    private static final String DATE_FORMAT_PATTERN2 = "EEE, d MMM yyyy HH:mm:ss.SSS Z";

    private LoggingTimestampConversionUtils() {
    }

    public static final String convertLoggingTimestampToUTCString(long loggingTimestamp) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(loggingTimestamp / 1000000L);
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_PATTERN2, Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(c.getTime()) + " (UTC)";
    }

    public static final String convertLoggingTimestampLocalTimeZoneString(long loggingTimestamp) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(loggingTimestamp / 1000000L);
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_PATTERN2, Locale.US);
        return dateFormat.format(c.getTime()) + " (local time)";
    }

    public static final long convertDatetimeStringToUTCLoggingTimestamp(String utcString) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_PATTERN, Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.parse(utcString).getTime();
    }

    public static final Date convertDatetimeStringToUTCDate(String utcString) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_PATTERN, Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.parse(utcString);
    }
}

