/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.util.signature;

import java.util.StringTokenizer;
import kieker.common.util.signature.Signature;

public class ClassOperationSignaturePair {
    private final int lastDot;
    private final String fqClassname;
    private final Signature signature;

    public ClassOperationSignaturePair(String fqClassname, Signature signature) {
        this.fqClassname = fqClassname;
        this.signature = signature;
        this.lastDot = fqClassname.lastIndexOf(46);
    }

    public String getFqClassname() {
        return this.fqClassname;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public String getSimpleClassname() {
        if (this.lastDot == -1) {
            return this.fqClassname;
        }
        return this.fqClassname.substring(this.lastDot + 1);
    }

    public String getPackageName() {
        if (this.lastDot == -1) {
            return "";
        }
        return this.fqClassname.substring(0, this.lastDot);
    }

    public String toOperationSignatureString() {
        return ClassOperationSignaturePair.createOperationSignatureString(this.fqClassname, this.signature);
    }

    public static ClassOperationSignaturePair splitOperationSignatureStr(String operationSignatureStr) {
        return ClassOperationSignaturePair.splitOperationSignatureStr(operationSignatureStr, false);
    }

    public static ClassOperationSignaturePair splitOperationSignatureStr(String operationSignatureStr, boolean javaConstructor) {
        String[] modifierList;
        String returnType;
        String name;
        String modRetName;
        String[] paramTypeList;
        int openParenIdx = operationSignatureStr.indexOf(40);
        if (openParenIdx == -1) {
            paramTypeList = new String[]{};
            modRetName = operationSignatureStr;
        } else {
            modRetName = operationSignatureStr.substring(0, openParenIdx);
            StringTokenizer strTokenizer = new StringTokenizer(operationSignatureStr.substring(openParenIdx + 1, operationSignatureStr.length() - 1), ",");
            paramTypeList = new String[strTokenizer.countTokens()];
            int i = 0;
            while (strTokenizer.hasMoreTokens()) {
                paramTypeList[i] = strTokenizer.nextToken().trim();
                ++i;
            }
        }
        int nameBeginIdx = modRetName.lastIndexOf(32);
        if (nameBeginIdx == -1) {
            name = modRetName;
            returnType = null;
            modifierList = new String[]{};
        } else {
            String[] modRetNameArr = modRetName.split("\\s");
            name = modRetNameArr[modRetNameArr.length - 1];
            if (javaConstructor) {
                returnType = null;
                modifierList = new String[modRetNameArr.length - 1];
            } else {
                returnType = modRetNameArr[modRetNameArr.length - 2];
                modifierList = new String[modRetNameArr.length - 2];
            }
            System.arraycopy(modRetNameArr, 0, modifierList, 0, modifierList.length);
        }
        int opNameIdx = name.lastIndexOf(46);
        String fqClassname = opNameIdx != -1 ? name.substring(0, opNameIdx) : "";
        String opName = name.substring(opNameIdx + 1);
        return new ClassOperationSignaturePair(fqClassname, new Signature(opName, modifierList, returnType, paramTypeList));
    }

    public static String createOperationSignatureString(String fqClassName, Signature signature) {
        StringBuilder strBuilder = new StringBuilder();
        if (signature.getReturnType() != null && signature.getReturnType().length() != 0) {
            for (String type : signature.getModifier()) {
                strBuilder.append(type).append(' ');
            }
            if (signature.hasReturnType()) {
                strBuilder.append(signature.getReturnType()).append(' ');
            }
        }
        strBuilder.append(fqClassName).append('.').append(signature.getName()).append('(');
        boolean first = true;
        for (String type : signature.getParamTypeList()) {
            if (!first) {
                strBuilder.append(", ");
            }
            first = false;
            strBuilder.append(type);
        }
        strBuilder.append(')');
        return strBuilder.toString();
    }

    public String toString() {
        return ClassOperationSignaturePair.createOperationSignatureString(this.fqClassname, this.signature);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fqClassname == null ? 0 : this.fqClassname.hashCode());
        result = 31 * result + this.lastDot;
        result = 31 * result + (this.signature == null ? 0 : this.signature.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClassOperationSignaturePair other = (ClassOperationSignaturePair)obj;
        if (this.fqClassname == null ? other.fqClassname != null : !this.fqClassname.equals(other.fqClassname)) {
            return false;
        }
        if (this.lastDot != other.lastDot) {
            return false;
        }
        return !(this.signature == null ? other.signature != null : !this.signature.equals(other.signature));
    }
}

