/*
 * Decompiled with CFR 0.152.
 */
package kieker.extension.cassandra;

import com.datastax.oss.driver.api.core.cql.Row;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.io.AbstractValueDeserializer;
import kieker.common.record.io.IValueDeserializer;

public class CassandraValueDeserializer
extends AbstractValueDeserializer
implements IValueDeserializer {
    private final Row row;
    private int column;

    public CassandraValueDeserializer(Row row) {
        this.row = row;
        this.column = 2;
    }

    @Override
    public boolean getBoolean() {
        return this.row.getBoolean(this.column++);
    }

    @Override
    public byte getByte() throws NumberFormatException {
        return this.row.getByte(this.column++);
    }

    @Override
    public char getChar() {
        return this.row.getString(this.column++).charAt(0);
    }

    @Override
    public short getShort() throws NumberFormatException {
        return this.row.getShort(this.column++);
    }

    @Override
    public int getInt() throws NumberFormatException {
        return this.row.getInt(this.column++);
    }

    @Override
    public long getLong() throws NumberFormatException {
        return this.row.getLong(this.column++);
    }

    @Override
    public float getFloat() throws NumberFormatException {
        return this.row.getFloat(this.column++);
    }

    @Override
    public double getDouble() throws NumberFormatException {
        return this.row.getDouble(this.column++);
    }

    @Override
    public String getString() {
        return this.row.getString(this.column++);
    }

    @Override
    public <T extends Enum<T>> T getEnumeration(Class<T> clazz) throws RecordInstantiationException {
        int value = this.row.getInt(this.column++);
        return this.enumerationValueOf(clazz, value);
    }
}

