/*
 * Decompiled with CFR 0.152.
 */
package kieker.extension.cassandra.reader;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.internal.core.cql.DefaultBoundStatement;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDb {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraDb.class);
    private final List<InetSocketAddress> contactPoints;
    private final String keyspace;
    private CqlSession session;
    private final Map<String, PreparedStatement> preparedStatements = new ConcurrentHashMap<String, PreparedStatement>();

    public CassandraDb(String keyspace, List<InetSocketAddress> contactPoints) {
        this.contactPoints = contactPoints;
        this.keyspace = keyspace;
    }

    public void connect() {
        try {
            this.session = (CqlSession)CqlSession.builder().build();
        }
        catch (Exception exc) {
            LOGGER.error("Opening Connection to Database failed. {}", (Object)exc.getLocalizedMessage());
        }
    }

    public void disconnect() {
        this.session.close();
    }

    public ResultSet select(List<String> fields, String table, String whereClause) {
        StringBuilder statement = new StringBuilder(200);
        statement.append("SELECT ");
        if (fields != null && !fields.isEmpty()) {
            for (String s : fields) {
                statement.append(s);
                statement.append(',');
            }
            statement.deleteCharAt(statement.length() - 1);
        } else {
            statement.append('*');
        }
        statement.append(" FROM ");
        statement.append(table);
        if (whereClause != null && !whereClause.isEmpty()) {
            statement.append(" WHERE ");
            statement.append(whereClause);
        }
        return this.execute(this.makeBoundStatement(statement.toString()));
    }

    private BoundStatement makeBoundStatement(String statement) {
        PreparedStatement preparedStatement = this.preparedStatements.get(statement);
        if (preparedStatement == null) {
            preparedStatement = this.session.prepare(statement);
            this.preparedStatements.put(statement, preparedStatement);
        }
        DefaultBoundStatement boundStatement = new DefaultBoundStatement(preparedStatement, null, null, statement, null, null, null, null, null, null, false, 0L, null, 0, null, null, null, null, null, null);
        return boundStatement;
    }

    private ResultSet execute(BoundStatement statement) {
        ResultSet resultSet = null;
        try {
            resultSet = this.session.execute((Statement)statement);
        }
        catch (Exception exc) {
            LOGGER.error("Error executing statement: {}", (Object)exc.getLocalizedMessage());
        }
        return resultSet;
    }
}

