/*
 * Decompiled with CFR 0.152.
 */
package kieker.extension.cassandra.reader;

import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import kieker.common.exception.ConfigurationException;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.factory.CachedRecordFactoryCatalog;
import kieker.common.record.factory.IRecordFactory;
import kieker.extension.cassandra.CassandraUtils;
import kieker.extension.cassandra.CassandraValueDeserializer;
import kieker.extension.cassandra.reader.CassandraDb;
import teetime.framework.AbstractProducerStage;

public class CassandraSourceStage
extends AbstractProducerStage<IMonitoringRecord> {
    private final CachedRecordFactoryCatalog recordFactories = CachedRecordFactoryCatalog.getInstance();
    private final String keyspace;
    private final List<InetSocketAddress> contactPoints;
    private final String tablePrefix;

    public CassandraSourceStage(String keyspace, String[] contactPoints, String tablePrefix) {
        this.keyspace = keyspace;
        this.contactPoints = CassandraUtils.computeDatabaseConnections(contactPoints);
        this.tablePrefix = tablePrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        CassandraDb database = null;
        try {
            database = new CassandraDb(this.keyspace, this.contactPoints);
            database.connect();
            ResultSet rs = database.select(new ArrayList<String>(), this.tablePrefix, null);
            for (Row r : rs) {
                String tablename = r.getString(1);
                String classname = r.getString(2);
                this.table2record(database, tablename, classname);
            }
        }
        catch (ConfigurationException exc) {
            this.logger.error(exc.getMessage());
        }
        finally {
            if (database != null) {
                database.disconnect();
            }
            this.logger.info("{} shutdown", (Object)((Object)((Object)this)).getClass().getSimpleName());
            this.workCompleted();
        }
    }

    private void table2record(CassandraDb database, String tablename, String eventTypeName) throws ConfigurationException {
        ResultSet rs = database.select(new ArrayList<String>(), tablename, null);
        for (Row row : rs) {
            if (rs.getAvailableWithoutFetching() != 10000 || !rs.isFullyFetched()) {
                // empty if block
            }
            if (row == null) continue;
            CassandraValueDeserializer deserializer = new CassandraValueDeserializer(row);
            int loggingTimestamp = deserializer.getInt();
            IRecordFactory<? extends IMonitoringRecord> eventTypeFactory = this.recordFactories.get(eventTypeName);
            if (eventTypeFactory == null) {
                this.logger.error("Class type {} was not found. Cannot instantiate event type.", (Object)eventTypeName);
                continue;
            }
            IMonitoringRecord record = eventTypeFactory.create(deserializer);
            record.setLoggingTimestamp(loggingTimestamp);
            this.outputPort.send((Object)record);
        }
    }
}

