/*
 * Decompiled with CFR 0.152.
 */
package kieker.model.analysismodel.statistics;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ESIUnitType implements Enumerator
{
    METER(0, "meter", "m"),
    GRAM(1, "gram", "g"),
    TON(2, "ton", "ton"),
    SECOND(3, "second", "s"),
    AMPERE(4, "ampere", "A"),
    KELVIN(5, "kelvin", "K"),
    MOLE(6, "mole", "mol"),
    CANDELA(7, "candela", "ca"),
    PASCAL(8, "pascal", "Pa"),
    JOUL(9, "Joul", "J");

    public static final int METER_VALUE = 0;
    public static final int GRAM_VALUE = 1;
    public static final int TON_VALUE = 2;
    public static final int SECOND_VALUE = 3;
    public static final int AMPERE_VALUE = 4;
    public static final int KELVIN_VALUE = 5;
    public static final int MOLE_VALUE = 6;
    public static final int CANDELA_VALUE = 7;
    public static final int PASCAL_VALUE = 8;
    public static final int JOUL_VALUE = 9;
    private static final ESIUnitType[] VALUES_ARRAY;
    public static final List<ESIUnitType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static ESIUnitType get(String literal) {
        for (ESIUnitType result : VALUES_ARRAY) {
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ESIUnitType getByName(String name) {
        for (ESIUnitType result : VALUES_ARRAY) {
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ESIUnitType get(int value) {
        switch (value) {
            case 0: {
                return METER;
            }
            case 1: {
                return GRAM;
            }
            case 2: {
                return TON;
            }
            case 3: {
                return SECOND;
            }
            case 4: {
                return AMPERE;
            }
            case 5: {
                return KELVIN;
            }
            case 6: {
                return MOLE;
            }
            case 7: {
                return CANDELA;
            }
            case 8: {
                return PASCAL;
            }
            case 9: {
                return JOUL;
            }
        }
        return null;
    }

    private ESIUnitType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new ESIUnitType[]{METER, GRAM, TON, SECOND, AMPERE, KELVIN, MOLE, CANDELA, PASCAL, JOUL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

