/*
 * Decompiled with CFR 0.152.
 */
package kieker.model.repository;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import kieker.model.repository.AbstractRepository;
import kieker.model.repository.AssemblyRepository;
import kieker.model.repository.ExecutionEnvironmentRepository;
import kieker.model.repository.SystemModelRepository;
import kieker.model.system.model.AllocationComponent;
import kieker.model.system.model.AssemblyComponent;
import kieker.model.system.model.ExecutionContainer;

public class AllocationRepository
extends AbstractRepository {
    public static final AllocationComponent ROOT_ALLOCATION_COMPONENT = new AllocationComponent(0, AssemblyRepository.ROOT_ASSEMBLY_COMPONENT, ExecutionEnvironmentRepository.ROOT_EXECUTION_CONTAINER);
    private final Map<String, AllocationComponent> allocationComponentInstancesByName = new Hashtable<String, AllocationComponent>();
    private final Map<Integer, AllocationComponent> allocationComponentInstancesById = new Hashtable<Integer, AllocationComponent>();

    public AllocationRepository(SystemModelRepository systemFactory) {
        super(systemFactory);
    }

    public final AllocationComponent lookupAllocationComponentInstanceByNamedIdentifier(String namedIdentifier) {
        return this.allocationComponentInstancesByName.get(namedIdentifier);
    }

    public final AllocationComponent createAndRegisterAllocationComponentInstance(String namedIdentifier, AssemblyComponent assemblyComponentInstance, ExecutionContainer executionContainer) {
        if (this.allocationComponentInstancesByName.containsKey(namedIdentifier)) {
            throw new IllegalArgumentException("Element with name " + namedIdentifier + "exists already");
        }
        int id = this.getAndIncrementNextId();
        AllocationComponent newInst = new AllocationComponent(id, assemblyComponentInstance, executionContainer);
        this.allocationComponentInstancesById.put(id, newInst);
        this.allocationComponentInstancesByName.put(namedIdentifier, newInst);
        return newInst;
    }

    public final Collection<AllocationComponent> getAllocationComponentInstances() {
        return this.allocationComponentInstancesById.values();
    }
}

