/*
 * Decompiled with CFR 0.152.
 */
package kieker.model.system.model;

import kieker.model.system.model.Execution;

public abstract class AbstractMessage {
    private final long timestamp;
    private final Execution sendingExecution;
    private final Execution receivingExecution;

    public AbstractMessage(long timestamp, Execution sendingExecution, Execution receivingExecution) {
        this.timestamp = timestamp;
        this.sendingExecution = sendingExecution;
        this.receivingExecution = receivingExecution;
    }

    public final Execution getReceivingExecution() {
        return this.receivingExecution;
    }

    public final Execution getSendingExecution() {
        return this.sendingExecution;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        StringBuilder strBuild = new StringBuilder();
        strBuild.append(this.timestamp).append(' ');
        if (this.getSendingExecution().getOperation().getId() == 0) {
            strBuild.append("'Entry'");
        } else {
            strBuild.append(this.getSendingExecution());
        }
        strBuild.append(" --> ");
        if (this.getReceivingExecution().getOperation().getId() == 0) {
            strBuild.append("'Entry'");
        } else {
            strBuild.append(this.getReceivingExecution());
        }
        return strBuild.toString();
    }

    public abstract boolean equals(Object var1);

    public int hashCode() {
        return (int)(this.timestamp ^ this.timestamp >>> 32);
    }
}

