/*
 * Decompiled with CFR 0.152.
 */
package kieker.model.system.model;

import java.util.Collections;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import kieker.model.system.model.AbstractTrace;

public abstract class AbstractSession<T extends AbstractTrace> {
    private final SortedSet<T> containedTraces;
    private final String sessionId;
    private volatile long startTime = Long.MAX_VALUE;
    private volatile long endTime = Long.MIN_VALUE;
    private volatile ISessionState<T> state = new ModifiableState();

    public AbstractSession(String sessionId) {
        this.sessionId = sessionId;
        this.containedTraces = new TreeSet<T>(this.getOrderComparator());
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void addTrace(T trace) {
        this.state.addTrace(trace);
    }

    public SortedSet<T> getStateContainedTraces() {
        return this.state.getContainedTraces();
    }

    public long getStartTimestamp() {
        return this.state.getStartTimestamp();
    }

    public long getEndTimestamp() {
        return this.state.getEndTimestamp();
    }

    protected long getStartTime() {
        return this.startTime;
    }

    protected long getEndTime() {
        return this.endTime;
    }

    protected void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    protected void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    protected void setState(ISessionState<T> state) {
        this.state = state;
    }

    protected SortedSet<T> getContainedTraces() {
        return this.containedTraces;
    }

    public void setCompleted() {
        this.state.setCompleted();
    }

    protected abstract Comparator<? super T> getOrderComparator();

    private class ModifiableState
    implements ISessionState<T> {
        @Override
        public synchronized void addTrace(T trace) {
            if (!AbstractSession.this.getContainedTraces().add(trace)) {
                return;
            }
            if (((AbstractTrace)trace).getStartTimestamp() < AbstractSession.this.getStartTime()) {
                AbstractSession.this.setStartTime(((AbstractTrace)trace).getStartTimestamp());
            }
            if (((AbstractTrace)trace).getEndTimestamp() > AbstractSession.this.getEndTime()) {
                AbstractSession.this.setEndTime(((AbstractTrace)trace).getEndTimestamp());
            }
        }

        @Override
        public synchronized SortedSet<T> getContainedTraces() {
            return Collections.unmodifiableSortedSet(AbstractSession.this.getContainedTraces());
        }

        @Override
        public synchronized long getStartTimestamp() {
            if (AbstractSession.this.getContainedTraces().isEmpty()) {
                return 0L;
            }
            return AbstractSession.this.getStartTime();
        }

        @Override
        public synchronized long getEndTimestamp() {
            if (AbstractSession.this.getContainedTraces().isEmpty()) {
                return 0L;
            }
            return AbstractSession.this.getEndTime();
        }

        @Override
        public synchronized void setCompleted() {
            AbstractSession.this.setState(new UnmodifiableState());
        }
    }

    private static interface ISessionState<T extends AbstractTrace> {
        public void addTrace(T var1);

        public SortedSet<T> getContainedTraces();

        public long getStartTimestamp();

        public long getEndTimestamp();

        public void setCompleted();
    }

    private class UnmodifiableState
    implements ISessionState<T> {
        @Override
        public void addTrace(T trace) {
        }

        @Override
        public SortedSet<T> getContainedTraces() {
            return Collections.unmodifiableSortedSet(AbstractSession.this.getContainedTraces());
        }

        @Override
        public long getStartTimestamp() {
            if (AbstractSession.this.getContainedTraces().isEmpty()) {
                return 0L;
            }
            return AbstractSession.this.getStartTime();
        }

        @Override
        public long getEndTimestamp() {
            if (AbstractSession.this.getContainedTraces().isEmpty()) {
                return 0L;
            }
            return AbstractSession.this.getEndTime();
        }

        @Override
        public void setCompleted() {
        }
    }
}

