/*
 * Decompiled with CFR 0.152.
 */
package kieker.model.system.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import kieker.common.util.dataformat.LoggingTimestampConversionUtils;
import kieker.model.system.model.AbstractMessage;
import kieker.model.system.model.AbstractTrace;
import kieker.model.system.model.Execution;
import kieker.model.system.model.MessageTrace;
import kieker.model.system.model.SynchronousCallMessage;
import kieker.model.system.model.SynchronousReplyMessage;
import kieker.model.system.model.exceptions.InvalidTraceException;

public class ExecutionTrace
extends AbstractTrace {
    private final AtomicReference<MessageTrace> messageTraceReference = new AtomicReference();
    private int minEoi = -1;
    private int maxEoi = -1;
    private long minTin = -1L;
    private long maxTout = -1L;
    private int maxEss = -1;
    private final SortedSet<Execution> trace = new TreeSet<Execution>(ExecutionTrace.createExecutionTraceComparator());
    private final SortedSet<Execution> unmodifiableExecutions = Collections.unmodifiableSortedSet(this.trace);

    public ExecutionTrace(long traceId) {
        super(traceId);
    }

    public ExecutionTrace(long traceId, String sessionId) {
        super(traceId, sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Execution execution) throws InvalidTraceException {
        ExecutionTrace executionTrace = this;
        synchronized (executionTrace) {
            if (this.getTraceId() != execution.getTraceId()) {
                throw new InvalidTraceException(String.format("TraceId of new record (%d) differs from Id of this trace (%d)", execution.getTraceId(), this.getTraceId()));
            }
            if (this.minTin < 0L || execution.getTin() < this.minTin) {
                this.minTin = execution.getTin();
            }
            if (this.maxTout < 0L || execution.getTout() > this.maxTout) {
                this.maxTout = execution.getTout();
            }
            if (this.minEoi < 0 || execution.getEoi() < this.minEoi) {
                this.minEoi = execution.getEoi();
            }
            if (this.maxEoi < 0 || execution.getEoi() > this.maxEoi) {
                this.maxEoi = execution.getEoi();
            }
            if (execution.getEss() > this.maxEss) {
                this.maxEss = execution.getEss();
            }
            this.trace.add(execution);
            this.messageTraceReference.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageTrace toMessageTrace(Execution rootExecution) throws InvalidTraceException {
        ExecutionTrace executionTrace = this;
        synchronized (executionTrace) {
            MessageTrace messageTrace = this.messageTraceReference.get();
            if (messageTrace != null) {
                return messageTrace;
            }
            ArrayList<AbstractMessage> messages = new ArrayList<AbstractMessage>();
            Stack<SynchronousCallMessage> currentMessageStack = new Stack<SynchronousCallMessage>();
            Iterator executionsIterator = this.trace.iterator();
            Execution previousExecution = rootExecution;
            int previousEoi = -1;
            boolean expectingEntryCall = true;
            while (executionsIterator.hasNext()) {
                Execution currentExecution = (Execution)executionsIterator.next();
                if (expectingEntryCall && currentExecution.getEss() != 0) {
                    throw new InvalidTraceException(String.format("First execution must have ess 0 (found %d)\n Causing execution: %s", currentExecution.getEss(), currentExecution.toString()));
                }
                expectingEntryCall = false;
                if (previousEoi != currentExecution.getEoi() - 1) {
                    throw new InvalidTraceException(String.format("Eois must increment by 1 -- but found sequence <%d,%d> (Execution: %s)", previousEoi, currentExecution.getEoi(), currentExecution.toString()));
                }
                previousEoi = currentExecution.getEoi();
                if (!previousExecution.equals(rootExecution) && previousExecution.getEss() >= currentExecution.getEss()) {
                    while (currentMessageStack.size() > currentExecution.getEss()) {
                        AbstractMessage poppedCall = (AbstractMessage)currentMessageStack.pop();
                        previousExecution = poppedCall.getReceivingExecution();
                        Execution currentReturnReceiver = poppedCall.getSendingExecution();
                        SynchronousReplyMessage message = new SynchronousReplyMessage(previousExecution.getTout(), previousExecution, currentReturnReceiver);
                        messages.add(message);
                        previousExecution = currentReturnReceiver;
                    }
                }
                SynchronousCallMessage callMessage = this.createCallMessage(rootExecution, previousExecution, currentExecution);
                messages.add(callMessage);
                currentMessageStack.push(callMessage);
                if (!executionsIterator.hasNext()) {
                    while (!currentMessageStack.empty()) {
                        AbstractMessage poppedCall = (AbstractMessage)currentMessageStack.pop();
                        previousExecution = poppedCall.getReceivingExecution();
                        Execution curReturnReceiver = poppedCall.getSendingExecution();
                        SynchronousReplyMessage message = new SynchronousReplyMessage(previousExecution.getTout(), previousExecution, curReturnReceiver);
                        messages.add(message);
                        previousExecution = curReturnReceiver;
                    }
                }
                previousExecution = currentExecution;
            }
            messageTrace = new MessageTrace(this.getTraceId(), this.getSessionId(), messages);
            this.messageTraceReference.set(messageTrace);
            return messageTrace;
        }
    }

    private SynchronousCallMessage createCallMessage(Execution rootExecution, Execution prevE, Execution curE) throws InvalidTraceException {
        SynchronousCallMessage message;
        if (prevE.equals(rootExecution)) {
            message = new SynchronousCallMessage(curE.getTin(), rootExecution, curE);
        } else if (prevE.getEss() + 1 == curE.getEss()) {
            message = new SynchronousCallMessage(curE.getTin(), prevE, curE);
        } else {
            if (prevE.getEss() < curE.getEss()) {
                InvalidTraceException ex = new InvalidTraceException("Ess are only allowed to increment by 1 --but found sequence <" + prevE.getEss() + "," + curE.getEss() + ">(Execution: " + curE + ")");
                throw ex;
            }
            String errorMessage = "Unexpected trace: " + prevE + " and " + curE;
            throw new IllegalStateException(errorMessage);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SortedSet<Execution> getTraceAsSortedExecutionSet() {
        ExecutionTrace executionTrace = this;
        synchronized (executionTrace) {
            return this.unmodifiableExecutions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getLength() {
        ExecutionTrace executionTrace = this;
        synchronized (executionTrace) {
            return this.trace.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder strBuild = new StringBuilder(512);
        ExecutionTrace executionTrace = this;
        synchronized (executionTrace) {
            strBuild.append("TraceId ").append(this.getTraceId());
            strBuild.append(" (minTin=").append(this.minTin);
            strBuild.append(" (").append(LoggingTimestampConversionUtils.convertLoggingTimestampToUTCString(this.minTin));
            strBuild.append("); maxTout=").append(this.maxTout);
            strBuild.append(" (").append(LoggingTimestampConversionUtils.convertLoggingTimestampToUTCString(this.maxTout));
            strBuild.append("); maxEss=").append(this.maxEss).append("):\n");
            for (Execution e : this.trace) {
                strBuild.append('<');
                strBuild.append(e.toString()).append(">\n");
            }
        }
        return strBuild.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxEss() {
        ExecutionTrace executionTrace = this;
        synchronized (executionTrace) {
            return this.maxEss;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxEoi() {
        ExecutionTrace executionTrace = this;
        synchronized (executionTrace) {
            return this.maxEoi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMinEoi() {
        ExecutionTrace executionTrace = this;
        synchronized (executionTrace) {
            return this.minEoi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDuration() {
        ExecutionTrace executionTrace = this;
        synchronized (executionTrace) {
            return this.getMaxTout() - this.minTin;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxTout() {
        ExecutionTrace executionTrace = this;
        synchronized (executionTrace) {
            return this.maxTout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMinTin() {
        ExecutionTrace executionTrace = this;
        synchronized (executionTrace) {
            return this.minTin;
        }
    }

    @Override
    public long getStartTimestamp() {
        return this.getMinTin();
    }

    @Override
    public long getEndTimestamp() {
        return this.getMaxTout();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object obj) {
        ExecutionTrace executionTrace = this;
        synchronized (executionTrace) {
            if (!(obj instanceof ExecutionTrace)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            ExecutionTrace other = (ExecutionTrace)obj;
            if (this.getTraceId() != other.getTraceId()) {
                return false;
            }
            return this.trace.equals(other.trace);
        }
    }

    public static final Comparator<Execution> createExecutionTraceComparator() {
        return new ExecutionTraceComparator();
    }

    private static final class ExecutionTraceComparator
    implements Comparator<Execution>,
    Serializable {
        private static final long serialVersionUID = -6334359132236475506L;

        @Override
        public final int compare(Execution e1, Execution e2) {
            if (e1.equals(e2)) {
                return 0;
            }
            if (e1.getTraceId() < e2.getTraceId()) {
                return -1;
            }
            if (e1.getTraceId() > e2.getTraceId()) {
                return 1;
            }
            if (e1.getEoi() < e2.getEoi()) {
                return -1;
            }
            if (e1.getEoi() > e2.getEoi()) {
                return 1;
            }
            if (e1.getEss() < e2.getEss()) {
                return -1;
            }
            if (e1.getEss() > e2.getEss()) {
                return 1;
            }
            if (e1.getTin() < e2.getTin()) {
                return -1;
            }
            if (e1.getTin() > e2.getTin()) {
                return 1;
            }
            if (e1.getTout() < e2.getTout()) {
                return -1;
            }
            if (e1.getTout() > e2.getTout()) {
                return 1;
            }
            return e1.hashCode() - e2.hashCode();
        }
    }
}

