/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.core.controller;

import kieker.common.configuration.Configuration;
import kieker.monitoring.core.controller.AbstractController;
import kieker.monitoring.core.controller.IRemoteController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.core.controller.tcp.TcpRecordReader;
import kieker.monitoring.listener.MonitoringCommandListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPController
extends AbstractController
implements IRemoteController {
    private static final int DEFAULT_BUFFER_SIZE = 65535;
    private static final Logger LOGGER = LoggerFactory.getLogger(TCPController.class);
    private static final String BUFFER_SIZE = TCPController.class.getCanonicalName() + ".bufferSize";
    private final String domain;
    private TcpRecordReader tcpReader;
    private boolean tcpEnabled;
    private Thread readerThread;

    protected TCPController(Configuration configuration, MonitoringController monitoringController) {
        super(configuration);
        int bufferSize = configuration.getIntProperty(BUFFER_SIZE, 65535);
        this.domain = configuration.getStringProperty("kieker.monitoring.tcp.domain");
        MonitoringCommandListener listener = new MonitoringCommandListener(monitoringController);
        try {
            int port = Integer.parseInt(configuration.getStringProperty("kieker.monitoring.tcp.remote.port"));
            this.tcpEnabled = configuration.getBooleanProperty("kieker.monitoring.tcp");
            this.tcpReader = new TcpRecordReader(port, bufferSize, LOGGER, true, listener);
            LOGGER.info("Setup of TCPController listening at {}", (Object)port);
            this.readerThread = new Thread(this.tcpReader);
        }
        catch (NumberFormatException e) {
            this.tcpEnabled = false;
            this.readerThread = null;
            LOGGER.info("Could not parse port for the TCPController, deactivating this option. Received string was: {}", (Object)configuration.getStringProperty("kieker.monitoring.tcp.remote.port"));
        }
    }

    @Override
    public String getControllerDomain() {
        return this.domain;
    }

    @Override
    protected void init() {
        if (this.tcpEnabled) {
            LOGGER.info("TCP reader for remote commands started");
            this.readerThread.start();
        }
    }

    @Override
    protected void cleanup() {
        if (this.tcpEnabled) {
            LOGGER.info("TCP reader for remote commands terminated");
            this.tcpReader.terminate();
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(255);
        sb.append("TCPController: ");
        if (this.tcpEnabled) {
            sb.append("TCP enabled (Domain: '");
            sb.append(this.domain);
            sb.append("')\n");
        } else {
            sb.append("TCP disabled\n");
        }
        return sb.toString();
    }
}

