/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.core.registry;

import java.security.SecureRandom;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kieker.common.record.flow.trace.ApplicationTraceMetadata;
import kieker.common.record.flow.trace.TraceMetadata;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.core.registry.SessionRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum TraceRegistry {
    INSTANCE;

    private static final Logger LOGGER;
    private final AtomicInteger nextTraceId = new AtomicInteger(0);
    private final long unique = MonitoringController.getInstance().isDebug() ? 0L : (long)new SecureRandom().nextInt() << 32;
    private final String hostname = MonitoringController.getInstance().getHostname();
    private final ThreadLocal<TraceMetadata> traceStorage = new ThreadLocal();
    private final ThreadLocal<Stack<TraceMetadata>> enclosingTraceStack = new ThreadLocal();
    private final WeakHashMap<Thread, TracePoint> parentTrace = new WeakHashMap();

    private final long getNewId() {
        return this.unique | (long)this.nextTraceId.getAndIncrement();
    }

    public final TraceMetadata getTrace() {
        return this.traceStorage.get();
    }

    public final ApplicationTraceMetadata registerTrace() {
        int parentOrderId;
        long parentTraceId;
        TraceMetadata enclosingTrace = this.getTrace();
        if (enclosingTrace != null) {
            Stack<TraceMetadata> localTraceStack = this.enclosingTraceStack.get();
            if (localTraceStack == null) {
                localTraceStack = new Stack();
                this.enclosingTraceStack.set(localTraceStack);
            }
            localTraceStack.push(enclosingTrace);
        }
        Thread thread = Thread.currentThread();
        TracePoint tp = this.getAndRemoveParentTraceId(thread);
        long traceId = this.getNewId();
        if (tp != null) {
            if (enclosingTrace != null && enclosingTrace.getTraceId() != tp.traceId) {
                LOGGER.error("Enclosing trace does not match split point. Found: {} expected: {}", (Object)enclosingTrace.getTraceId(), (Object)enclosingTrace.getTraceId());
            }
            parentTraceId = tp.traceId;
            parentOrderId = tp.orderId;
        } else if (enclosingTrace != null) {
            parentTraceId = enclosingTrace.getTraceId();
            parentOrderId = -1;
        } else {
            parentTraceId = traceId;
            parentOrderId = -1;
        }
        String sessionId = SessionRegistry.INSTANCE.recallThreadLocalSessionId();
        String applicationName = MonitoringController.getInstance().getApplicationName();
        ApplicationTraceMetadata trace = new ApplicationTraceMetadata(traceId, thread.getId(), sessionId, this.hostname, parentTraceId, parentOrderId, applicationName);
        this.traceStorage.set(trace);
        return trace;
    }

    public final void unregisterTrace() {
        Stack<TraceMetadata> localTraceStack = this.enclosingTraceStack.get();
        if (localTraceStack != null) {
            if (!localTraceStack.isEmpty()) {
                this.traceStorage.set(localTraceStack.pop());
            } else {
                this.enclosingTraceStack.remove();
                this.traceStorage.remove();
            }
        } else {
            this.traceStorage.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TracePoint getAndRemoveParentTraceId(Thread t) {
        TraceRegistry traceRegistry = this;
        synchronized (traceRegistry) {
            return this.parentTrace.remove(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setParentTraceId(Thread t, long traceId, int orderId) {
        TraceRegistry traceRegistry = this;
        synchronized (traceRegistry) {
            this.parentTrace.put(t, new TracePoint(traceId, orderId));
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(TraceRegistry.class);
    }

    private static final class TracePoint {
        public final long traceId;
        public final int orderId;

        public TracePoint(long traceId, int orderId) {
            this.traceId = traceId;
            this.orderId = orderId;
        }
    }
}

